/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.squareup.javapoet.TypeName;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.DbConfig;
import de.thomas_oster.lazysql.MssqlAdapter;
import de.thomas_oster.lazysql.MysqlAdapter;
import de.thomas_oster.lazysql.OracleAdapter;
import de.thomas_oster.lazysql.UnknownRDBMSAdapter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ClassUtils;

public abstract class AbstractRDBMSAdapter {
    static final Map<Integer, Class> mappingNullable = new LinkedHashMap<Integer, Class>();

    protected final void tryToLoadDriver(String className) {
        try {
            Class<?> driver = Class.forName(className);
            DriverManager.registerDriver((Driver)driver.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
            Logger.getLogger(MssqlAdapter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    FullyQualifiedName getFqn(Connection con, String name) throws SQLException {
        FullyQualifiedName result = new FullyQualifiedName();
        String[] parts = name.split("[.]", -1);
        switch (parts.length) {
            case 3: {
                result.catalog = parts[0];
                result.schema = parts[1];
                result.name = parts[2];
                break;
            }
            case 2: {
                result.catalog = con.getCatalog();
                result.schema = parts[0];
                result.name = parts[1];
                break;
            }
            default: {
                result.catalog = con.getCatalog();
                result.schema = con.getSchema();
                result.name = name;
            }
        }
        return result;
    }

    public static AbstractRDBMSAdapter getAdapterByDbUri(String dburi, String customDriver) throws DbConfig.ConfigException {
        String driver = dburi.split(":")[1];
        if ("sqlserver".equals(driver)) {
            return new MssqlAdapter();
        }
        if ("mysql".equals(driver)) {
            return new MysqlAdapter();
        }
        if ("oracle".equals(driver)) {
            return new OracleAdapter();
        }
        return new UnknownRDBMSAdapter(customDriver);
    }

    protected Class getColumnType(int DATA_TYPE, String TYPE_NAME, int NULLABLE) {
        Class type = mappingNullable.get(DATA_TYPE);
        return type;
    }

    public List<String> getSchemas(Connection con, String catalog, String prefix) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        ResultSet r = con.getMetaData().getSchemas(catalog, prefix != null ? prefix + "%" : null);
        while (r.next()) {
            result.add(r.getString("TABLE_SCHEM"));
        }
        return result;
    }

    public List<String> getSchemas(Connection con, String prefix) throws SQLException {
        return this.getSchemas(con, con.getCatalog(), prefix);
    }

    protected List<Argument> getInsertableTableColumns(Connection con, String catalog, String schema, String name, String prefix) throws SQLException {
        LinkedList<Argument> result = new LinkedList<Argument>();
        ResultSet r = con.getMetaData().getColumns(catalog, schema, name, prefix != null ? prefix + "%" : null);
        while (r.next()) {
            Class type;
            boolean autoincrement = "YES".equals(r.getString("IS_AUTOINCREMENT"));
            boolean generated = false;
            try {
                generated = "YES".equals(r.getString("IS_GENERATEDCOLUMN"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            boolean optional = false;
            try {
                if (r.getString("COLUMN_DEF") != null && !"null".equals(r.getString("COLUMN_DEF"))) {
                    optional = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (autoincrement || generated || (type = this.getColumnType(r.getInt("DATA_TYPE"), r.getString("TYPE_NAME"), r.getInt("NULLABLE"))) == null) continue;
            result.add(new Argument(r.getString("COLUMN_NAME"), type, optional));
        }
        if (result.isEmpty()) {
            throw new SQLException("Unknown table `" + name + "`");
        }
        return result;
    }

    protected List<Argument> getTableColumns(Connection con, String catalog, String schema, String name, String prefix) throws SQLException {
        LinkedList<Argument> result = new LinkedList<Argument>();
        ResultSet r = con.getMetaData().getColumns(catalog, schema, name, prefix != null ? prefix + "%" : null);
        while (r.next()) {
            Class type = this.getColumnType(r.getInt("DATA_TYPE"), r.getString("TYPE_NAME"), r.getInt("NULLABLE"));
            if (type == null) continue;
            result.add(new Argument(r.getString("COLUMN_NAME"), type, false));
        }
        if (result.isEmpty()) {
            throw new SQLException("Unknown table `" + name + "`");
        }
        return result;
    }

    public List<Argument> getTableColumns(Connection con, String name, String prefix) throws SQLException {
        FullyQualifiedName fqn = this.getFqn(con, name);
        return this.getTableColumns(con, fqn.catalog, fqn.schema, fqn.name, prefix);
    }

    public List<Argument> getInsertableTableColumns(Connection con, String name, String prefix) throws SQLException {
        FullyQualifiedName fqn = this.getFqn(con, name);
        return this.getInsertableTableColumns(con, fqn.catalog, fqn.schema, fqn.name, prefix);
    }

    public List<Argument> getStoredProcedureParameters(Connection con, String catalog, String schema, String name) throws SQLException, NotSupportedException {
        LinkedList<Argument> result = new LinkedList<Argument>();
        ResultSet r = con.getMetaData().getProcedureColumns(catalog, schema, name, null);
        while (r.next()) {
            Class primitive;
            if (r.getInt("COLUMN_TYPE") > 3) continue;
            Class type = mappingNullable.get(r.getInt("DATA_TYPE"));
            if (type == null) {
                throw new SQLException("Cannot map SQL Type " + r.getInt("DATA_TYPE"));
            }
            if (r.getInt("NULLABLE") == 0 && (primitive = ClassUtils.wrapperToPrimitive((Class)type)) != null) {
                type = primitive;
            }
            Argument.Direction dir = Argument.Direction.IN;
            if (r.getInt("COLUMN_TYPE") == 2) {
                dir = Argument.Direction.OUT;
            }
            result.add(new Argument(r.getString("COLUMN_NAME").replace("@", ""), TypeName.get((Type)type), dir, false));
        }
        if (result.isEmpty()) {
            throw new SQLException("Unknown procedure `" + name + "`");
        }
        return result;
    }

    public List<Argument> getStoredProcedureParameters(Connection con, String name) throws SQLException, NotSupportedException {
        FullyQualifiedName fqn = this.getFqn(con, name);
        return this.getStoredProcedureParameters(con, fqn.catalog, fqn.schema, fqn.name);
    }

    public List<Procedure> getStoredProcedures(Connection con, String catalog, String schema, String prefix) throws SQLException, NotSupportedException {
        LinkedList<Procedure> result = new LinkedList<Procedure>();
        try (ResultSet r = con.getMetaData().getProcedures(catalog, schema, prefix + "%");){
            while (r.next()) {
                Procedure p = new Procedure();
                p.name = r.getString("PROCEDURE_NAME");
                p.comment = r.getString("REMARKS");
                result.add(p);
            }
            r.close();
        }
        return result;
    }

    public List<Procedure> getStoredProcedures(Connection con, String prefix) throws SQLException, NotSupportedException {
        FullyQualifiedName fqn = this.getFqn(con, prefix);
        return this.getStoredProcedures(con, fqn.catalog, fqn.schema, fqn.name);
    }

    public abstract List<Argument> getSqlQueryType(Connection var1, String var2, List<Argument> var3) throws SQLException, NotSupportedException;

    public abstract void checkSQLSyntax(Connection var1, String var2, List<Argument> var3) throws SQLException, NotSupportedException;

    public List<String> getTables(Connection db, String catalog, String schema, String prefix) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        ResultSet r = db.getMetaData().getTables(catalog, schema, prefix == null ? null : prefix + "%", null);
        while (r.next()) {
            result.add(r.getString("TABLE_NAME"));
        }
        r.close();
        return result;
    }

    public List<String> getTables(Connection db, String prefix) throws SQLException {
        FullyQualifiedName fqn = this.getFqn(db, prefix);
        return this.getTables(db, fqn.catalog, fqn.schema, fqn.name);
    }

    static {
        mappingNullable.put(1, String.class);
        mappingNullable.put(12, String.class);
        mappingNullable.put(-1, String.class);
        mappingNullable.put(-16, String.class);
        mappingNullable.put(-9, String.class);
        mappingNullable.put(-15, String.class);
        mappingNullable.put(2, BigDecimal.class);
        mappingNullable.put(3, BigDecimal.class);
        mappingNullable.put(-7, Boolean.class);
        mappingNullable.put(-6, Byte.class);
        mappingNullable.put(5, Short.class);
        mappingNullable.put(4, Integer.class);
        mappingNullable.put(-5, BigInteger.class);
        mappingNullable.put(7, Float.class);
        mappingNullable.put(6, Double.class);
        mappingNullable.put(8, Double.class);
        mappingNullable.put(-2, byte[].class);
        mappingNullable.put(-3, byte[].class);
        mappingNullable.put(-4, byte[].class);
        mappingNullable.put(91, Date.class);
        mappingNullable.put(92, Time.class);
        mappingNullable.put(93, Timestamp.class);
        mappingNullable.put(2005, Clob.class);
        mappingNullable.put(2003, Array.class);
        mappingNullable.put(2002, Struct.class);
        mappingNullable.put(2006, Ref.class);
        mappingNullable.put(2000, Object.class);
    }

    public static class FullyQualifiedName {
        String catalog;
        String schema;
        String name;
    }

    public static class Procedure {
        String name;
        String comment;

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Procedure)) {
                return false;
            }
            Procedure other = (Procedure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Procedure;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRDBMSAdapter.Procedure(name=" + this.getName() + ", comment=" + this.getComment() + ")";
        }
    }

    public static class NotSupportedException
    extends Exception {
        public NotSupportedException(String reason) {
            super(reason);
        }
    }
}

