/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class TypeHelper {
    private static final BiMap<String, TypeName> typeFromString;

    static String getSQLType(TypeName type) {
        if (type.equals((Object)TypeName.get(Integer.class))) {
            return "java.sql.Types.INTEGER";
        }
        return "java.sql.Types.VARCHAR";
    }

    public static String getSimpleName(String s) {
        String[] parts = s.split("\\.");
        return parts[parts.length - 1];
    }

    public static String getSimpleName(TypeName t) {
        return TypeHelper.getSimpleName(t.toString());
    }

    public static TypeName typeFromString(String simpleName) throws UnknownTypeException {
        TypeName r = (TypeName)typeFromString.get((Object)simpleName);
        if (r == null) {
            throw new UnknownTypeException("Type " + simpleName + " ist unbekannt");
        }
        return r;
    }

    public static String stringFromType(TypeName t) throws UnknownTypeException {
        String r = (String)typeFromString.inverse().get((Object)t);
        if (r == null) {
            throw new UnknownTypeException("No simple name for Type " + t);
        }
        return r;
    }

    static {
        Class[] classes = new Class[]{String.class, Integer.class, Double.class, byte[].class, Date.class, Boolean.class, Short.class, Long.class, Float.class, Byte.class, Byte.TYPE, Integer.TYPE, Double.TYPE, Short.TYPE, Boolean.TYPE, BigDecimal.class, BigInteger.class, Timestamp.class};
        typeFromString = HashBiMap.create((int)classes.length);
        for (Class c : classes) {
            typeFromString.put((Object)c.getSimpleName(), (Object)TypeName.get((Type)c));
        }
    }

    public static class UnknownTypeException
    extends Exception {
        public UnknownTypeException(String message) {
            super(message);
        }
    }
}

