/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.squareup.javapoet.TypeName;
import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.TypeHelper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class MssqlAdapter
extends AbstractRDBMSAdapter {
    public MssqlAdapter() {
        this.tryToLoadDriver("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @Override
    public List<AbstractRDBMSAdapter.Procedure> getStoredProcedures(Connection con, String catalog, String schema, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        List<AbstractRDBMSAdapter.Procedure> result = super.getStoredProcedures(con, catalog, schema, prefix);
        result.forEach(p -> p.setName(p.getName().split(";")[0]));
        return result;
    }

    @Override
    protected Class getColumnType(int DATA_TYPE, String TYPE_NAME, int NULLABLE) {
        if ("timestamp".equals(TYPE_NAME)) {
            return null;
        }
        return super.getColumnType(DATA_TYPE, TYPE_NAME, NULLABLE);
    }

    @Override
    public List<Argument> getSqlQueryType(Connection con, String sql, List<Argument> params) throws SQLException {
        Statement stmtObj = con.createStatement();
        String paramsSQL = "";
        if (params != null) {
            paramsSQL = params.stream().map(p -> "@" + p.getName() + " " + this.getSQLType(p.getType())).collect(Collectors.joining(",", ", @params = N'", "'"));
        }
        ResultSet resObj = stmtObj.executeQuery("exec sp_describe_first_result_set @tsql = N'" + sql.replaceAll("'", "''") + "' " + paramsSQL);
        LinkedList<Argument> result = new LinkedList<Argument>();
        while (resObj.next()) {
            result.add(new Argument(resObj.getString("name"), this.toJavaType(resObj.getString("system_type_name"))));
        }
        return result;
    }

    private String getSQLType(TypeName t) {
        switch (TypeHelper.getSimpleName(t)) {
            case "String": {
                return "VARCHAR";
            }
            case "Integer": 
            case "int": {
                return "INT";
            }
            case "Date": {
                return "DATETIME";
            }
        }
        return "VARCHAR";
    }

    private Type toJavaType(String sqlType) throws SQLException {
        if (sqlType.startsWith("varchar") || sqlType.startsWith("nvarchar")) {
            return String.class;
        }
        if (sqlType.equals("int")) {
            return Integer.class;
        }
        if (sqlType.equals("tinyint")) {
            return Byte.class;
        }
        if (sqlType.startsWith("decimal") || sqlType.startsWith("numeric")) {
            return BigDecimal.class;
        }
        if (sqlType.startsWith("float")) {
            return Double.class;
        }
        if (sqlType.equals("xml")) {
            return String.class;
        }
        if (sqlType.equals("uniqueidentifier")) {
            return String.class;
        }
        if (sqlType.equals("datetime") || sqlType.equals("date")) {
            return Date.class;
        }
        if (sqlType.equals("timestamp") || sqlType.equals("image")) {
            return byte[].class;
        }
        if (sqlType.equals("char")) {
            return String.class;
        }
        if (sqlType.startsWith("char(") || sqlType.startsWith("text")) {
            return String.class;
        }
        if (sqlType.equals("bit")) {
            return Boolean.class;
        }
        if (sqlType.startsWith("bigint")) {
            return Long.class;
        }
        throw new SQLException("Unknown Type " + sqlType);
    }

    @Override
    public void checkSQLSyntax(Connection con, String sql, List<Argument> params) throws SQLException {
        block2: {
            try {
                this.getSqlQueryType(con, sql, params);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 11526) break block2;
                throw ex;
            }
        }
    }
}

