/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.AutoComplete;
import de.thomas_oster.lazysql.DbConfig;
import de.thomas_oster.lazysql.DbQueryTyper;
import de.thomas_oster.lazysql.ElementException;
import de.thomas_oster.lazysql.TypeHelper;
import de.thomas_oster.lazysql.annotations.LazySQLConfig;
import de.thomas_oster.lazysql.annotations.LazySQLExec;
import de.thomas_oster.lazysql.annotations.LazySQLInsert;
import de.thomas_oster.lazysql.annotations.LazySQLSelect;
import de.thomas_oster.lazysql.annotations.LazySQLStoredProcedure;
import de.thomas_oster.lazysql.annotations.LazySQLUpdate;
import de.thomas_oster.lazysql.annotations.LazySQLUpsert;
import de.thomas_oster.lazysql.annotations.Returns;
import de.thomas_oster.shaded_jilt.Builder;
import de.thomas_oster.shaded_jilt.BuilderStyle;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.sql.DataSource;
import javax.tools.Diagnostic;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

@SupportedAnnotationTypes(value={"de.thomas_oster.lazysql.annotations.LazySQLSelect", "de.thomas_oster.lazysql.annotations.LazySQLConfig", "de.thomas_oster.lazysql.annotations.LazySQLUpdate", "de.thomas_oster.lazysql.annotations.LazySQLExec", "de.thomas_oster.lazysql.annotations.LazySQLUpsert", "de.thomas_oster.lazysql.annotations.LazySQLInsert", "de.thomas_oster.lazysql.annotations.LazySQLStoredProcedure", "de.thomas_oster.layzsql.annotations.Returns"})
public class LazySQLProcessor
extends AbstractProcessor {
    private final Pattern sqlParams = Pattern.compile(":[a-zA-Z_]\\w*");
    private Messager messager;
    private Filer filer;
    private Elements elementUtils;
    private Map<String, ClassToGenerate> toGenerate = new LinkedHashMap<String, ClassToGenerate>();
    public static final boolean DEBUG_TO_FILE = false;

    private TypeName extractTypeName(String fqn) {
        int i = fqn.lastIndexOf(".");
        String packageName = fqn.substring(0, i);
        String returnType = fqn.substring(i + 1);
        return ClassName.get((String)packageName, (String)returnType, (String[])new String[0]);
    }

    public static List<? extends TypeMirror> getTypeMirrorFromAnnotationValue(GetClassValue c) {
        try {
            c.execute();
        }
        catch (MirroredTypesException ex) {
            return ex.getTypeMirrors();
        }
        return null;
    }

    public static TypeMirror getFirstTypeMirrorFromAnnotationValue(GetClassValue c) {
        block2: {
            try {
                c.execute();
            }
            catch (MirroredTypesException ex) {
                List<? extends TypeMirror> result = ex.getTypeMirrors();
                if (result == null || result.isEmpty()) break block2;
                return result.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void addMethodForSelect(String packageName, String className, TypeSpec.Builder lazyDbClass, LazySelect q) throws IOException {
        ClassName returnTypeClass;
        Object returnType = q.annotation.returnClassName();
        ClassName returnTypeInterface = returnTypeClass = ClassName.get((String)packageName, (String)className, (String[])new String[]{returnType});
        List<? extends TypeMirror> additionalInterfacesC = LazySQLProcessor.getTypeMirrorFromAnnotationValue(() -> q.annotation.additionalInterfacesC());
        boolean extraClassForReturnType = false;
        if (StringUtils.isEmpty((String)returnType)) {
            returnType = q.methodName.substring(0, 1).toUpperCase() + q.methodName.substring(1) + "Result";
            returnTypeInterface = returnTypeClass = ClassName.get((String)packageName, (String)className, (String[])new String[]{returnType});
            if (!StringUtils.isBlank((String)q.annotation.returnInterfaceName())) {
                returnTypeInterface = ClassName.get((String)packageName, (String)className, (String[])new String[]{q.annotation.returnInterfaceName()});
            } else if (additionalInterfacesC != null && additionalInterfacesC.size() == 1) {
                returnTypeInterface = ClassName.get((TypeMirror)additionalInterfacesC.get(0));
            } else if (q.annotation.additionalInterfaces().length == 1) {
                String iface = q.annotation.additionalInterfaces()[0];
                Object object = returnTypeInterface = iface.contains(".") ? this.extractTypeName(iface) : ClassName.get((String)packageName, (String)className, (String[])new String[]{iface});
            }
        }
        if (((String)returnType).contains(".")) {
            extraClassForReturnType = true;
            returnTypeInterface = returnTypeClass = this.extractTypeName((String)returnType);
        }
        MethodSpec.Builder queryMethod = MethodSpec.methodBuilder((String)q.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!q.annotation.convertSqlExceptionToRuntimeException()) {
            queryMethod.addException(SQLException.class);
        }
        if (!q.annotation.manageConnectionWithDatasource()) {
            queryMethod.addParameter(Connection.class, "con", new Modifier[0]);
        } else if (!q.config.dependencyInjection) {
            queryMethod.addParameter(DataSource.class, "ds", new Modifier[0]);
        }
        if (q.resultType.size() == 1) {
            if (q.annotation.returnFirstOrNull()) {
                queryMethod.returns(q.resultType.iterator().next().getType());
            } else {
                queryMethod.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{q.resultType.iterator().next().getType()}));
            }
        } else {
            if (!q.annotation.doNotGenerateClass()) {
                TypeSpec.Builder returnClass = this.buildMutableTypeFor((String)returnType, q.resultType, q.config.addJsonAnnotations);
                if (additionalInterfacesC != null) {
                    for (TypeMirror typeMirror : additionalInterfacesC) {
                        returnClass.addSuperinterface(ClassName.get((TypeMirror)typeMirror));
                    }
                }
                if (q.annotation.additionalInterfaces() != null) {
                    void var14_22;
                    String[] stringArray = q.annotation.additionalInterfaces();
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var14_22 < n) {
                        String iface = stringArray[var14_22];
                        TypeName interfaceName = iface.contains(".") ? this.extractTypeName(iface) : ClassName.get((String)packageName, (String)className, (String[])new String[]{iface});
                        returnClass.addSuperinterface(interfaceName);
                        ++var14_22;
                    }
                }
                if (!StringUtils.isBlank((String)q.annotation.returnInterfaceName())) {
                    TypeSpec.Builder returnInterfaceBuilder = this.buildInterfaceTypeFor(q.annotation.returnInterfaceName(), q.resultType);
                    if (q.annotation.additionalInterfaces() != null) {
                        for (String iface : q.annotation.additionalInterfaces()) {
                            TypeName interfaceName = iface.contains(".") ? this.extractTypeName(iface) : ClassName.get((String)packageName, (String)className, (String[])new String[]{iface});
                            returnInterfaceBuilder.addSuperinterface(interfaceName);
                        }
                    }
                    if (additionalInterfacesC != null) {
                        for (TypeMirror typeMirror : additionalInterfacesC) {
                            returnInterfaceBuilder.addSuperinterface(ClassName.get((TypeMirror)typeMirror));
                        }
                    }
                    TypeSpec typeSpec = returnInterfaceBuilder.build();
                    ClassName className2 = ClassName.get((String)packageName, (String)className, (String[])new String[]{q.annotation.returnInterfaceName()});
                    lazyDbClass.addType(typeSpec);
                    returnClass.addSuperinterface((TypeName)className2);
                }
                if (extraClassForReturnType) {
                    try {
                        JavaFile.builder((String)packageName, (TypeSpec)returnClass.build()).build().writeTo(this.filer);
                    }
                    catch (IOException ex) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), q.element);
                    }
                } else {
                    lazyDbClass.addType(returnClass.addModifiers(new Modifier[]{Modifier.STATIC}).build());
                }
            }
            if (q.annotation.returnFirstOrNull()) {
                queryMethod.returns((TypeName)returnTypeInterface);
            } else {
                queryMethod.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{returnTypeInterface}));
            }
        }
        if (q.annotation.dynamicWhereClause()) {
            queryMethod.addParameter(String.class, "whereClause", new Modifier[0]);
        }
        if (q.annotation.useObjectAsInput()) {
            String argumentTypeName = "InputFor" + WordUtils.capitalize((String)q.methodName);
            TypeSpec argumentType = this.buildTypeFor(argumentTypeName, q.params, true).build();
            JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
            queryMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
        } else {
            for (Argument a : q.params) {
                queryMethod.addParameter(a.getType(), a.getName(), new Modifier[0]);
            }
        }
        LinkedList<Argument> argumentsInQueryOrder = new LinkedList<Argument>();
        try {
            String query = this.replaceArgumentsAndListOrder(q.sqlQuery, q.params, argumentsInQueryOrder);
            CodeBlock.Builder builder = CodeBlock.builder();
            if (!q.annotation.manageConnectionWithDatasource()) {
                builder.beginControlFlow("try( \n\t$T stmtObj = con.prepareStatement(\"" + query + " \"" + (q.annotation.dynamicWhereClause() ? ".replace(\"{WHERE}\", whereClause)" : "") + ")\n)", new Object[]{PreparedStatement.class});
            } else {
                builder.beginControlFlow("try( \n\t$T con = ds.getConnection();\n\t$T stmtObj = con.prepareStatement(\"" + query + " \"" + (q.annotation.dynamicWhereClause() ? ".replace(\"{WHERE}\", whereClause)" : "") + ")\n)", new Object[]{Connection.class, PreparedStatement.class});
            }
            this.addCodeForSettingParameters(builder, argumentsInQueryOrder, q.annotation.useObjectAsInput());
            if (q.annotation.fetchSize() > 0) {
                builder.addStatement("stmtObj.setFetchSize(" + q.annotation.fetchSize() + ")", new Object[0]);
            }
            builder.addStatement("$T resObj = stmtObj.executeQuery()", new Object[]{ResultSet.class});
            if (q.resultType.size() == 1) {
                Argument argument = q.resultType.iterator().next();
                builder.addStatement("$L<$T> result = new $L<>()", new Object[]{TypeName.get(List.class), argument.getType(), TypeName.get(LinkedList.class)}).beginControlFlow("while (resObj.next())", new Object[0]);
                if (argument.getType().equals((Object)TypeName.get(Integer.class))) {
                    builder.addStatement("Integer j = resObj.getInt(\"" + argument.name + "\")", new Object[0]);
                    builder.addStatement("result.add(resObj.wasNull() ? null : j)", new Object[0]);
                } else if (argument.getType().equals((Object)TypeName.get(byte[].class))) {
                    builder.addStatement("result.add(resObj.getBytes(\"" + argument.name + "\"))", new Object[0]);
                } else {
                    builder.addStatement("result.add(resObj.get" + TypeHelper.getSimpleName(argument.getType()) + "(\"" + argument.name + "\"))", new Object[0]);
                }
            } else {
                builder.addStatement("$L<$T> result = new $L<>()", new Object[]{TypeName.get(List.class), returnTypeInterface, TypeName.get(LinkedList.class)}).beginControlFlow("while (resObj.next())", new Object[0]);
                builder.addStatement("    $T r = new $T()", new Object[]{returnTypeClass, returnTypeClass});
                for (Argument r : q.resultType) {
                    if (r.getType().equals((Object)TypeName.get(Integer.class))) {
                        builder.addStatement("r.set" + WordUtils.capitalize((String)r.name) + "(resObj.getInt(\"" + r.name + "\"))", new Object[0]);
                        builder.addStatement("if (resObj.wasNull()) { r.set" + WordUtils.capitalize((String)r.name) + "(null); }", new Object[0]);
                        continue;
                    }
                    if (r.getType().equals((Object)TypeName.get(byte[].class))) {
                        builder.addStatement("r.set" + WordUtils.capitalize((String)r.name) + " (resObj.getBytes(\"" + r.name + "\"))", new Object[0]);
                        continue;
                    }
                    builder.addStatement("r.set" + WordUtils.capitalize((String)r.name) + "(resObj.get" + TypeHelper.getSimpleName(r.getType()) + "(\"" + r.name + "\"))", new Object[0]);
                }
                builder.addStatement("result.add(r)", new Object[0]);
            }
            builder.endControlFlow();
            if (q.annotation.returnFirstOrNull()) {
                builder.addStatement("return result.isEmpty() ? null : result.get(0)", new Object[0]);
            } else {
                builder.addStatement("return result", new Object[0]);
            }
            builder.endControlFlow();
            if (q.annotation.convertSqlExceptionToRuntimeException()) {
                builder.beginControlFlow("catch ($T e)", new Object[]{SQLException.class});
                builder.addStatement("throw new $T(e)", new Object[]{RuntimeException.class});
                builder.endControlFlow();
            }
            queryMethod.addCode(builder.build());
            lazyDbClass.addMethod(queryMethod.build());
        }
        catch (Argument.MismatchException e) {
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), q.element);
        }
    }

    public String replaceArgumentsAndListOrder(String query, List<Argument> parameters, List<Argument> argumentsInQueryOrder) throws Argument.MismatchException {
        Matcher m = this.sqlParams.matcher(query);
        while (m.find()) {
            String name = m.group().substring(1);
            Optional<Argument> first = parameters.stream().filter(a -> a.getName().equals(name)).findFirst();
            if (!first.isPresent()) {
                throw new Argument.MismatchException("Query Parameter '" + name + "' nicht gefunden");
            }
            argumentsInQueryOrder.add(first.get());
            query = query.replaceFirst(":" + name + "\\b", "?");
            m = this.sqlParams.matcher(query);
        }
        return query;
    }

    private void addMethodForUpdate(String packageName, TypeSpec.Builder lazyDbClass, LazyUpdate q) throws IOException {
        MethodSpec.Builder queryMethod = MethodSpec.methodBuilder((String)q.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(SQLException.class);
        queryMethod.returns(Integer.TYPE);
        queryMethod.addParameter(Connection.class, "con", new Modifier[0]);
        if (q.annotation.dynamicWhereClause()) {
            queryMethod.addParameter(String.class, "whereClause", new Modifier[0]);
        }
        if (q.annotation.useObjectAsInput()) {
            String argumentTypeName = "InputFor" + WordUtils.capitalize((String)q.methodName);
            TypeSpec argumentType = this.buildTypeFor(argumentTypeName, q.params, true).build();
            JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
            queryMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
        } else {
            for (Argument a : q.params) {
                queryMethod.addParameter(a.getType(), a.getName(), new Modifier[0]);
            }
        }
        LinkedList<Argument> argumentsInQueryOrder = new LinkedList<Argument>();
        try {
            String query = this.replaceArgumentsAndListOrder(q.sqlQuery, q.params, argumentsInQueryOrder);
            CodeBlock.Builder methodBody = CodeBlock.builder();
            methodBody.beginControlFlow("try( \n\t$T stmtObj = con.prepareStatement(\"" + query + " \"" + (q.annotation.dynamicWhereClause() ? ".replace(\"{WHERE}\", whereClause)" : "") + "))", new Object[]{PreparedStatement.class});
            this.addCodeForSettingParameters(methodBody, argumentsInQueryOrder, q.annotation.useObjectAsInput());
            methodBody.addStatement("return stmtObj.executeUpdate()", new Object[0]);
            methodBody.endControlFlow();
            queryMethod.addCode(methodBody.build());
            lazyDbClass.addMethod(queryMethod.build());
        }
        catch (Argument.MismatchException e) {
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), q.element);
        }
    }

    private void addMethodForExec(String packageName, TypeSpec.Builder lazyDbClass, LazyExec q) throws IOException {
        MethodSpec.Builder queryMethod = MethodSpec.methodBuilder((String)q.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(SQLException.class);
        queryMethod.returns(Boolean.TYPE);
        queryMethod.addParameter(Connection.class, "con", new Modifier[0]);
        if (q.annotation.useObjectAsInput()) {
            String argumentTypeName = "InputFor" + WordUtils.capitalize((String)q.methodName);
            TypeSpec argumentType = this.buildTypeFor(argumentTypeName, q.params, true).build();
            JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
            queryMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
        } else {
            for (Argument a : q.params) {
                queryMethod.addParameter(a.getType(), a.getName(), new Modifier[0]);
            }
        }
        LinkedList<Argument> argumentsInQueryOrder = new LinkedList<Argument>();
        try {
            String query = this.replaceArgumentsAndListOrder(q.sqlQuery, q.params, argumentsInQueryOrder);
            CodeBlock.Builder methodBody = CodeBlock.builder();
            methodBody.beginControlFlow("try( \n\t$T stmtObj = con.prepareStatement(\"" + query + " \"))", new Object[]{PreparedStatement.class});
            this.addCodeForSettingParameters(methodBody, argumentsInQueryOrder, q.annotation.useObjectAsInput());
            methodBody.addStatement("return stmtObj.execute()", new Object[0]);
            methodBody.endControlFlow();
            queryMethod.addCode(methodBody.build());
            lazyDbClass.addMethod(queryMethod.build());
        }
        catch (Argument.MismatchException e) {
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), q.element);
        }
    }

    private TypeSpec.Builder buildInterfaceTypeFor(String name, List<Argument> arguments) {
        TypeSpec.Builder argumentType = TypeSpec.interfaceBuilder((String)name);
        argumentType.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (Argument a : arguments) {
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)("get" + WordUtils.capitalize((String)a.getName())));
            getter.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            getter.returns(a.getType());
            argumentType.addMethod(getter.build());
            MethodSpec.Builder setter = MethodSpec.methodBuilder((String)("set" + WordUtils.capitalize((String)a.getName())));
            setter.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            setter.addParameter(a.getType(), a.getName(), new Modifier[0]);
            argumentType.addMethod(setter.build());
        }
        return argumentType;
    }

    private TypeSpec.Builder buildMutableTypeFor(String name, List<Argument> arguments, boolean useJacksonAnnotation) {
        TypeSpec.Builder argumentType = TypeSpec.classBuilder((String)name);
        argumentType.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Argument a : arguments) {
            argumentType.addField(a.getType(), a.getName(), new Modifier[0]);
        }
        for (Argument a : arguments) {
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)("get" + WordUtils.capitalize((String)a.getName())));
            getter.addModifiers(new Modifier[]{Modifier.PUBLIC});
            getter.returns(a.getType());
            getter.addCode(CodeBlock.of((String)("return this." + a.getName() + ";\n"), (Object[])new Object[0]));
            if (useJacksonAnnotation) {
                getter.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "\"" + a.getName() + "\"", new Object[0]).build());
            }
            argumentType.addMethod(getter.build());
            MethodSpec.Builder setter = MethodSpec.methodBuilder((String)("set" + WordUtils.capitalize((String)a.getName())));
            setter.addModifiers(new Modifier[]{Modifier.PUBLIC});
            setter.addParameter(a.getType(), a.getName(), new Modifier[0]);
            setter.addCode(CodeBlock.of((String)("this." + a.getName() + " = " + a.getName() + ";\n"), (Object[])new Object[0]));
            argumentType.addMethod(setter.build());
        }
        return argumentType;
    }

    private TypeSpec.Builder buildTypeFor(String name, List<Argument> arguments, boolean createBuilder) {
        TypeSpec.Builder argumentType = TypeSpec.classBuilder((String)name);
        argumentType.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        for (Argument argument : arguments) {
            argumentType.addField(argument.getType(), argument.getName(), new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        }
        MethodSpec.Builder aConst = MethodSpec.constructorBuilder();
        if (createBuilder) {
            aConst.addAnnotation(AnnotationSpec.builder(Builder.class).addMember("style", CodeBlock.of((String)"$T.$L", (Object[])new Object[]{BuilderStyle.class, BuilderStyle.TYPE_SAFE.name()})).build());
        }
        for (Argument a : arguments) {
            aConst.addParameter(a.getType(), a.getName(), new Modifier[0]);
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (Argument a : arguments) {
            builder.addStatement("this." + a.getName() + " = " + a.getName(), new Object[0]);
        }
        aConst.addCode(builder.build());
        argumentType.addMethod(aConst.build());
        for (Argument a : arguments) {
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)("get" + WordUtils.capitalize((String)a.getName().toString())));
            getter.addModifiers(new Modifier[]{Modifier.PUBLIC});
            getter.returns(a.getType());
            getter.addCode(CodeBlock.of((String)("return this." + a.getName() + ";"), (Object[])new Object[0]));
            argumentType.addMethod(getter.build());
        }
        return argumentType;
    }

    private void addMethodForInsert(String packageName, TypeSpec.Builder classBuilder, LazyInsert p) throws IOException {
        MethodSpec.Builder spMethod = MethodSpec.methodBuilder((String)p.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(SQLException.class);
        spMethod.returns(Boolean.class);
        spMethod.addParameter(Connection.class, "con", new Modifier[0]);
        if (p.annotation.useObjectAsInput()) {
            String argumentTypeName = "InputFor" + WordUtils.capitalize((String)p.methodName);
            TypeSpec argumentType = this.buildTypeFor(argumentTypeName, p.fields, true).build();
            JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
            spMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
        } else {
            for (Argument a : p.fields) {
                spMethod.addParameter(a.getType(), a.getName(), new Modifier[0]);
            }
        }
        String argsString = p.fields.isEmpty() ? "" : "(" + StringUtils.repeat((String)"?,", (int)(p.fields.size() - 1)) + "?)";
        String argumentList = p.fields.stream().map(Argument::getName).collect(Collectors.joining(","));
        CodeBlock.Builder methodBody = CodeBlock.builder();
        methodBody.beginControlFlow("try( \n\t$T stmtObj = con.prepareStatement(\"insert into " + p.tableName + " (" + argumentList + ") VALUES " + argsString + "\"))", new Object[]{PreparedStatement.class});
        this.addCodeForSettingParameters(methodBody, p.fields, p.annotation.useObjectAsInput());
        methodBody.addStatement("return stmtObj.execute()", new Object[0]);
        methodBody.endControlFlow();
        spMethod.addCode(methodBody.build());
        classBuilder.addMethod(spMethod.build());
    }

    private void addMethodForUpsert(String packageName, TypeSpec.Builder classBuilder, LazyUpsert p) throws IOException {
        MethodSpec.Builder spMethod = MethodSpec.methodBuilder((String)p.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(SQLException.class);
        spMethod.returns(Boolean.class);
        spMethod.addParameter(Connection.class, "con", new Modifier[0]);
        Set<String> separateParams = Set.of(p.annotation.separateParams());
        TypeMirror classAsInput = LazySQLProcessor.getFirstTypeMirrorFromAnnotationValue(() -> p.annotation.useClassAsInput());
        if (!p.annotation.useObjectAsInput()) {
            for (Argument a2 : p.fields) {
                spMethod.addParameter(a2.getType(), a2.getName(), new Modifier[0]);
            }
        } else {
            if (classAsInput != null && classAsInput.getKind() != TypeKind.VOID) {
                spMethod.addParameter(ClassName.get((TypeMirror)classAsInput), "i", new Modifier[0]);
            } else if (p.annotation.useObjectAsInput()) {
                String argumentTypeName = "InputFor" + WordUtils.capitalize((String)p.methodName);
                List<Argument> fieldsWithoutSeparateParams = p.fields;
                if (!separateParams.isEmpty()) {
                    fieldsWithoutSeparateParams = p.fields.stream().filter(f -> !separateParams.contains(f.name)).toList();
                }
                TypeSpec argumentType = this.buildTypeFor(argumentTypeName, fieldsWithoutSeparateParams, true).build();
                JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
                spMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
            }
            for (Argument a2 : p.fields) {
                if (!separateParams.contains(a2.name)) continue;
                spMethod.addParameter(a2.getType(), a2.getName(), new Modifier[0]);
            }
        }
        String argsString = p.fields.isEmpty() ? "" : "(" + StringUtils.repeat((String)"?,", (int)(p.fields.size() - 1)) + "?)";
        String argumentList = p.fields.stream().map(Argument::getName).collect(Collectors.joining(","));
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(p.tableName).append(" SET ").append(p.toUpdate.stream().map(it -> it + " = ? ").collect(Collectors.joining(","))).append(" WHERE ").append(p.keys.stream().map(it -> it + " = ? ").collect(Collectors.joining(" AND "))).append(" IF @@ROWCOUNT=0 ").append("INSERT INTO ").append(p.tableName).append(" (").append(argumentList).append(") ").append("VALUES ").append(argsString);
        CodeBlock.Builder methodBody = CodeBlock.builder().beginControlFlow("try(\n\t$T stmtObj = con.prepareStatement(\"" + sql.toString() + "\"))", new Object[]{PreparedStatement.class});
        LinkedList<Argument> params = new LinkedList<Argument>();
        params.addAll(Stream.concat(p.fields.stream().filter(a -> p.toUpdate.contains(a.name)), p.fields.stream().filter(a -> p.keys.contains(a.name))).toList());
        params.addAll(p.fields);
        this.addCodeForSettingParameters(methodBody, params, p.annotation.useObjectAsInput(), separateParams);
        methodBody.addStatement("return stmtObj.execute()", new Object[0]);
        methodBody.endControlFlow();
        spMethod.addCode(methodBody.build());
        classBuilder.addMethod(spMethod.build());
    }

    private void addCodeForSettingParameters(CodeBlock.Builder methodBody, List<Argument> arguments, boolean useGetters) {
        this.addCodeForSettingParameters(methodBody, arguments, useGetters, Set.of());
    }

    private void addCodeForSettingParameters(CodeBlock.Builder methodBody, List<Argument> arguments, boolean useGetters, Set<String> excludeGetters) {
        int i = 0;
        for (Argument a : arguments) {
            ++i;
            if (a.dir == Argument.Direction.IN || a.dir == Argument.Direction.INOUT) {
                String value;
                String string = value = useGetters && !excludeGetters.contains(a.getName()) ? "i.get" + WordUtils.capitalize((String)a.getName()) + "()" : a.getName();
                if ("Date".equals(TypeHelper.getSimpleName(a.getType()))) {
                    methodBody.addStatement("stmtObj.setTimestamp(" + i + ", " + value + " == null ? null : new $T(" + value + ".getTime()))", new Object[]{Timestamp.class});
                } else if ("BigInteger".equals(TypeHelper.getSimpleName(a.getType()))) {
                    methodBody.addStatement("stmtObj.setBigDecimal(" + i + ", " + value + " == null ? null : new $T(" + value + "))", new Object[]{BigDecimal.class});
                } else if ("Integer".equals(TypeHelper.getSimpleName(a.getType()))) {
                    methodBody.beginControlFlow("if (" + value + " != null)", new Object[0]).addStatement("stmtObj.setInt(" + i + ", " + value + ")", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("stmtObj.setNull(" + i + ", java.sql.Types.INTEGER)", new Object[0]).endControlFlow();
                } else {
                    Object setMethod = "set" + StringUtils.capitalize((String)TypeHelper.getSimpleName(a.getType()));
                    if ("setByte[]".equals(setMethod)) {
                        setMethod = "setBytes";
                    }
                    methodBody.addStatement("stmtObj." + (String)setMethod + "(" + i + ", " + value + ")", new Object[0]);
                }
            }
            if (a.dir != Argument.Direction.OUT) continue;
            methodBody.addStatement("stmtObj.registerOutParameter(" + i + ", " + TypeHelper.getSQLType(a.getType()) + ")", new Object[0]);
        }
    }

    private void addMethodForStoredProcedure(String packageName, String className, TypeSpec.Builder classBuilder, LazyProcedure p) throws IOException {
        List<Argument> inputParams = p.params.stream().filter(x -> x.dir == Argument.Direction.IN || x.dir == Argument.Direction.INOUT).collect(Collectors.toList());
        List<Argument> outputParams = p.params.stream().filter(x -> x.dir == Argument.Direction.OUT || x.dir == Argument.Direction.INOUT).collect(Collectors.toList());
        String returnType = p.methodName.substring(0, 1).toUpperCase() + p.methodName.substring(1) + "Result";
        ClassName returnTypeClass = ClassName.get((String)packageName, (String)className, (String[])new String[]{returnType});
        MethodSpec.Builder spMethod = MethodSpec.methodBuilder((String)p.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(SQLException.class);
        spMethod.addParameter(Connection.class, "con", new Modifier[0]);
        if (outputParams.isEmpty()) {
            spMethod.returns(Boolean.class);
        } else if (outputParams.size() == 1) {
            spMethod.returns(((Argument)outputParams.get(0)).getType());
        } else {
            classBuilder.addType(this.buildMutableTypeFor(returnType, outputParams, p.config.addJsonAnnotations).addModifiers(new Modifier[]{Modifier.STATIC}).build());
            spMethod.returns((TypeName)returnTypeClass);
        }
        if (p.annotation.useObjectAsInput()) {
            String argumentTypeName = "InputFor" + WordUtils.capitalize((String)p.methodName);
            TypeSpec argumentType = this.buildTypeFor(argumentTypeName, inputParams, true).build();
            JavaFile.builder((String)packageName, (TypeSpec)argumentType).build().writeTo(this.filer);
            spMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)argumentTypeName, (String[])new String[0]), "i", new Modifier[0]);
        } else {
            for (Argument a : inputParams) {
                spMethod.addParameter(a.getType(), a.getName(), new Modifier[0]);
            }
        }
        String argsString = p.params.isEmpty() ? "" : "(" + StringUtils.repeat((String)"?,", (int)(p.params.size() - 1)) + "?)";
        CodeBlock.Builder methodBody = CodeBlock.builder().beginControlFlow("try(\n\t$T stmtObj = con.prepareCall(\"{call " + p.procedureName + argsString + "}\"))", new Object[]{CallableStatement.class});
        this.addCodeForSettingParameters(methodBody, p.params, p.annotation.useObjectAsInput());
        if (outputParams.isEmpty()) {
            methodBody.addStatement("return stmtObj.execute()", new Object[0]);
        } else if (outputParams.size() == 1) {
            methodBody.addStatement("stmtObj.execute()", new Object[0]);
            Argument r = outputParams.get(0);
            int idx = p.params.indexOf(r) + 1;
            if (r.getType().equals((Object)TypeName.get(Integer.class))) {
                methodBody.addStatement("Integer r = stmtObj.getInt(" + idx + ")", new Object[0]);
                methodBody.addStatement("return stmtObj.wasNull() ? null : r", new Object[0]);
            } else if (r.getType().equals((Object)TypeName.get(byte[].class))) {
                methodBody.addStatement("return stmtObj.getBytes(" + idx + ")", new Object[0]);
            } else {
                methodBody.addStatement("return stmtObj.get" + TypeHelper.getSimpleName(r.getType()) + "(" + idx + ")", new Object[0]);
            }
        } else {
            methodBody.addStatement("stmtObj.execute()", new Object[0]);
            methodBody.addStatement("$T r = new $T()", new Object[]{returnTypeClass, returnTypeClass});
            for (Argument r : outputParams) {
                int idx = p.params.indexOf(r) + 1;
                if (r.getType().equals((Object)TypeName.get(Integer.class))) {
                    methodBody.addStatement("r.set" + WordUtils.capitalize((String)r.name) + "(resObj.getInt(" + idx + "))", new Object[0]);
                    methodBody.addStatement("if (resObj.wasNull()) { r.set" + WordUtils.capitalize((String)r.name) + "(null); }", new Object[0]);
                    continue;
                }
                if (r.getType().equals((Object)TypeName.get(byte[].class))) {
                    methodBody.addStatement("r.set" + WordUtils.capitalize((String)r.name) + " (resObj.getBytes(" + idx + "))", new Object[0]);
                    continue;
                }
                methodBody.addStatement("r.set" + WordUtils.capitalize((String)r.name) + "(resObj.get" + TypeHelper.getSimpleName(r.getType()) + "(" + idx + "))", new Object[0]);
            }
            methodBody.addStatement("return r", new Object[0]);
        }
        methodBody.endControlFlow();
        spMethod.addCode(methodBody.build());
        classBuilder.addMethod(spMethod.build());
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        LinkedList<Completion> result = new LinkedList<Completion>();
        for (Completion completion : super.getCompletions(element, annotation, member, userText)) {
            result.add(completion);
        }
        for (Completion completion : AutoComplete.getCompletions(this, element, annotation, member, userText)) {
            result.add(completion);
        }
        return result;
    }

    private List<Argument> getArgumentsFromStringOrMethod(String[] params, Element method) throws Argument.ParsingException {
        if (params == null || params.length == 0 || params.length == 1 && StringUtils.isEmpty((String)params[0])) {
            ExecutableElement typeElement = (ExecutableElement)method;
            return Argument.fromVariableElements(typeElement.getParameters().stream().filter(p -> !"java.sql.Connection".equals(p.asType().toString()) && !"javax.sql.DataSource".equals(p.asType().toString())).collect(Collectors.toList()));
        }
        return Argument.fromTypeListString(String.join((CharSequence)",", params).replace(",,", ","));
    }

    private void processInsertAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLInsert.class)) {
            LazySQLInsert annotation = element.getAnnotation(LazySQLInsert.class);
            try {
                this.assertElementIsMethod(element);
                List<Argument> argumentsFromMethod = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db != null) {
                    try {
                        List<Argument> paramsFromSQL = tg.db.getInsertableTableColumns(annotation.value(), null);
                        try {
                            Argument.compareWithOrder(argumentsFromMethod, paramsFromSQL);
                        }
                        catch (Argument.MismatchException ex) {
                            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
                            argumentsFromMethod = paramsFromSQL;
                        }
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
                    }
                }
                LazyInsert lq = new LazyInsert();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.tableName = annotation.value();
                lq.fields = argumentsFromMethod;
                lq.element = element;
                lq.annotation = annotation;
                lq.config = tg.config;
                tg.inserts.add(lq);
            }
            catch (ElementException | SQLException ex) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
            }
        }
    }

    private void assertElementIsMethod(Element element) throws ElementException {
        if (element.getKind() != ElementKind.METHOD) {
            throw new ElementException("Annotation can only be applied to Methods");
        }
    }

    private List<String> joinCommaSeparated(String[] params) {
        return Arrays.stream(String.join((CharSequence)",", params).replace(",,", ",").split(",")).map(String::trim).filter(x -> !Strings.isNullOrEmpty((String)x)).collect(Collectors.toList());
    }

    private void processUpsertAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLUpsert.class)) {
            LazySQLUpsert annotation = element.getAnnotation(LazySQLUpsert.class);
            try {
                List<String> keys;
                this.assertElementIsMethod(element);
                List<Argument> argumentsFromMethod = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db != null) {
                    try {
                        List<Argument> paramsFromSQL = tg.db.getInsertableTableColumns(annotation.table(), null);
                        try {
                            Argument.compareWithOrder(argumentsFromMethod, paramsFromSQL);
                        }
                        catch (Argument.MismatchException ex) {
                            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
                            argumentsFromMethod = paramsFromSQL;
                        }
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
                    }
                }
                if ((keys = this.joinCommaSeparated(annotation.keys())).isEmpty()) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "You must specify the keys", element);
                    continue;
                }
                Set argumentNames = argumentsFromMethod.stream().map(Argument::getName).collect(Collectors.toSet());
                Optional<String> missing = keys.stream().filter(k -> !argumentNames.contains(k)).findAny();
                if (missing.isPresent()) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Key " + missing.get() + " is not a valid table columnn", element);
                    continue;
                }
                List<String> toUpdate = this.joinCommaSeparated(annotation.onlyUpdate());
                if (toUpdate.isEmpty()) {
                    toUpdate = argumentsFromMethod.stream().map(Argument::getName).filter(it -> !keys.contains(it)).collect(Collectors.toList());
                } else {
                    missing = toUpdate.stream().filter(k -> !argumentNames.contains(k)).findAny();
                    if (missing.isPresent()) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "onlyUpdate: " + missing.get() + " is not a valid table columnn", element);
                        continue;
                    }
                }
                LazyUpsert lq = new LazyUpsert();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.tableName = annotation.table();
                lq.fields = argumentsFromMethod;
                lq.keys = keys;
                lq.element = element;
                lq.annotation = annotation;
                lq.config = tg.config;
                lq.toUpdate = toUpdate;
                tg.upserts.add(lq);
            }
            catch (ElementException | SQLException ex) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
            }
        }
    }

    private void generateDatabaseClass(ClassToGenerate tg, Filer filer) throws IOException {
        TypeSpec.Builder lazyDbClass = TypeSpec.classBuilder((String)tg.className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (tg.config.dependencyInjection) {
            lazyDbClass.addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0]));
            if (tg.selects.stream().anyMatch(s -> s.annotation.manageConnectionWithDatasource())) {
                ClassName dataSourceType = ClassName.get((String)"javax.sql", (String)"DataSource", (String[])new String[0]);
                lazyDbClass.addField((TypeName)dataSourceType, "ds", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
                lazyDbClass.addMethod(MethodSpec.constructorBuilder().addAnnotation(ClassName.get((String)"jakarta.inject", (String)"Inject", (String[])new String[0])).addParameter((TypeName)dataSourceType, "dataSource", new Modifier[0]).addCode("this.ds = dataSource;\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
            }
        }
        for (LazyProcedure lazyProcedure : tg.procedures) {
            this.addMethodForStoredProcedure(tg.packageName, tg.className, lazyDbClass, lazyProcedure);
        }
        for (LazyInsert lazyInsert : tg.inserts) {
            this.addMethodForInsert(tg.packageName, lazyDbClass, lazyInsert);
        }
        for (LazyUpsert lazyUpsert : tg.upserts) {
            this.addMethodForUpsert(tg.packageName, lazyDbClass, lazyUpsert);
        }
        for (LazySelect lazySelect : tg.selects) {
            this.addMethodForSelect(tg.packageName, tg.className, lazyDbClass, lazySelect);
        }
        for (LazyExec lazyExec : tg.execs) {
            this.addMethodForExec(tg.packageName, lazyDbClass, lazyExec);
        }
        for (LazyUpdate lazyUpdate : tg.updates) {
            this.addMethodForUpdate(tg.packageName, lazyDbClass, lazyUpdate);
        }
        JavaFile.builder((String)tg.packageName, (TypeSpec)lazyDbClass.build()).build().writeTo(filer);
    }

    public static void debugLog(String text) {
        try {
            FileUtils.writeStringToFile((File)new File("/tmp/debug"), (String)(text + "\n"), (String)"utf8", (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DbConfig findConfig(Element method, RoundEnvironment roundEnvironment) {
        try {
            DbConfig cfg;
            LazySQLConfig config;
            Element clazz = method.getEnclosingElement();
            if (clazz.getKind() == ElementKind.CLASS && (config = clazz.getAnnotation(LazySQLConfig.class)) != null) {
                return DbConfig.fromConfigAnnotation(config);
            }
            if (roundEnvironment != null) {
                for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLConfig.class)) {
                    LazySQLConfig config2 = element.getAnnotation(LazySQLConfig.class);
                    if (config2 == null || !config2.global()) continue;
                    return DbConfig.fromConfigAnnotation(config2);
                }
            }
            if ((cfg = DbConfig.fromEnvironment()) != null) {
                return cfg;
            }
        }
        catch (DbConfig.ConfigException e) {
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), method);
        }
        try {
            return DbConfig.fromConfigFile("lazysql.json");
        }
        catch (DbConfig.ConfigException configException) {
            try {
                return DbConfig.fromConfigFile("lazysql.yml");
            }
            catch (DbConfig.ConfigException configException2) {
                try {
                    return DbConfig.fromSpringBootConfig("application.yml");
                }
                catch (DbConfig.ConfigException configException3) {
                    return null;
                }
            }
        }
    }

    DbQueryTyper getDatabaseForElement(Element method, RoundEnvironment roundEnvironment, Messager messager) {
        try {
            DbConfig cfg = this.findConfig(method, roundEnvironment);
            return new DbQueryTyper(cfg, messager);
        }
        catch (DbConfig.ConfigException | SQLException ex) {
            messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), method);
        }
        catch (NullPointerException e) {
            return null;
        }
        try {
            return new DbQueryTyper(null, messager);
        }
        catch (DbConfig.ConfigException | SQLException e) {
            messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), method);
            return null;
        }
    }

    private void processStoredProcedureAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLStoredProcedure.class)) {
            try {
                this.assertElementIsMethod(element);
                LazySQLStoredProcedure annotation = element.getAnnotation(LazySQLStoredProcedure.class);
                List<Argument> arguments = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db != null) {
                    try {
                        List<Argument> paramsFromSQL = tg.db.getStoredProcedureParameters(String.join((CharSequence)"", annotation.value()));
                        try {
                            Argument.compareWithOrder(arguments, paramsFromSQL);
                        }
                        catch (Argument.MismatchException e) {
                            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), element);
                            arguments = paramsFromSQL;
                        }
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, ex.getLocalizedMessage(), element);
                    }
                } else if (arguments.isEmpty()) {
                    throw new ElementException("Without a DB connection, we need a params declaration");
                }
                LazyProcedure lq = new LazyProcedure();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.procedureName = annotation.value();
                lq.params = arguments;
                lq.element = element;
                lq.annotation = annotation;
                lq.config = tg.config;
                tg.procedures.add(lq);
            }
            catch (ElementException | SQLException e) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), element);
            }
        }
    }

    public void checkIfAllArgumentsAreUsed(String sql, List<Argument> arguments, Element element) throws ElementException {
        for (Argument e : arguments) {
            String name = e.getName();
            if (!Pattern.compile(":" + name + "\\b").matcher(sql).find()) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Der Methodenparameter " + name + " wird nicht in der SQL Query verwendet", element);
            }
            sql = sql.replaceAll(":" + name + "\\b", "?");
        }
        Matcher m = this.sqlParams.matcher(sql);
        if (m.find()) {
            throw new ElementException("Die SQL Variable " + m.group() + " existiert nicht als Parameter");
        }
    }

    private void processSelectAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLSelect.class)) {
            try {
                this.assertElementIsMethod(element);
                LazySQLSelect annotation = element.getAnnotation(LazySQLSelect.class);
                String sql = this.extractQuery(annotation.value());
                if (annotation.dynamicWhereClause() && !sql.contains("{WHERE}")) {
                    throw new ElementException("Your query must contain {WHERE} when using dynamic where clause");
                }
                List<Argument> argumentsFromMethod = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                this.checkIfAllArgumentsAreUsed(sql, argumentsFromMethod, element);
                Returns ran = element.getAnnotation(Returns.class);
                String rav = ran != null ? ran.value() : String.join((CharSequence)",", annotation.returns()).replace(",,", ",");
                List<Argument> type = null;
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db == null) {
                    if (StringUtils.isEmpty((String)rav)) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot determine the result Type. You need a returns value or a database connection.", element);
                        continue;
                    }
                    type = Argument.fromTypeListString(rav);
                    if (type == null) {
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot determine the result Type. Invalid returns annotation.", element);
                        continue;
                    }
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "No DB Connection. The return type is not checked whatsoever", element);
                } else {
                    String checksql = sql.replaceAll(":", "@");
                    if (annotation.dynamicWhereClause()) {
                        checksql = checksql.replace("{WHERE}", "WHERE 1 = 1");
                    }
                    try {
                        String[] excludedColumns;
                        type = tg.db.getSqlQueryType(checksql, argumentsFromMethod);
                        String[] stringArray = excludedColumns = annotation.excludeColumns() != null ? annotation.excludeColumns() : tg.config.excludeColumns;
                        if (excludedColumns != null) {
                            LinkedHashSet<String> exclude = new LinkedHashSet<String>(Arrays.stream(excludedColumns).toList());
                            type.removeIf(t -> exclude.contains(t.name));
                        }
                        String asText = Argument.toTypeListString(type);
                        if (!StringUtils.isEmpty((String)rav)) {
                            List<Argument> at = Argument.fromTypeListString(rav);
                            try {
                                Argument.compareWithoutOrder(type, at);
                            }
                            catch (Argument.MismatchException e) {
                                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "returns information is different from Database: " + e.getLocalizedMessage() + "\nShould be:\n" + asText, element);
                            }
                        } else {
                            this.messager.printMessage(Diagnostic.Kind.WARNING, "Should have returns information:\nreturns = \"" + asText + "\"", element);
                        }
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        type = Argument.fromTypeListString(rav);
                        if (type == null) {
                            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot determine the result Type. Invalid returns annotation.", element);
                            continue;
                        }
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
                        this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The return type is not checked whatsoever", element);
                    }
                }
                LazySelect lq = new LazySelect();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.resultType = type;
                lq.sqlQuery = sql;
                lq.params = argumentsFromMethod;
                lq.annotation = annotation;
                lq.element = element;
                lq.config = tg.config;
                tg.selects.add(lq);
            }
            catch (ElementException | SQLException ex) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), element);
            }
        }
    }

    private void processUpdateAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLUpdate.class)) {
            try {
                this.assertElementIsMethod(element);
                LazySQLUpdate annotation = element.getAnnotation(LazySQLUpdate.class);
                String sql = this.extractQuery(annotation.value());
                List<Argument> argumentsFromMethod = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                this.checkIfAllArgumentsAreUsed(sql, argumentsFromMethod, element);
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db == null) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Ohne Datenbankverbindung wird die Query nicht weiter gepr\u00fcft.", element);
                } else {
                    try {
                        tg.db.checkSQLSyntax(sql.replaceAll(":", "@"), argumentsFromMethod);
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, ex.getLocalizedMessage(), element);
                    }
                }
                LazyUpdate lq = new LazyUpdate();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.sqlQuery = sql;
                lq.params = argumentsFromMethod;
                lq.element = element;
                lq.annotation = annotation;
                lq.config = tg.config;
                tg.updates.add(lq);
            }
            catch (ElementException | SQLException e) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), element);
            }
        }
    }

    private String extractQuery(String[] annotationValue) throws ElementException {
        String result = String.join((CharSequence)" ", annotationValue).replace("\n", " ").replace("\r", "");
        if (result.startsWith("file://")) {
            String filename = result.replaceFirst("file://", "");
            File f = DbConfig.findFileInDirOrParents(DbConfig.findResourcesDir(), filename, 3);
            if (f == null || !f.exists()) {
                throw new ElementException("File " + filename + " not found");
            }
            try {
                result = FileUtils.readFileToString((File)f, (String)"UTF8");
            }
            catch (IOException ex) {
                throw new ElementException(ex.getLocalizedMessage());
            }
        }
        return result;
    }

    private void processExecAnnotations(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazySQLExec.class)) {
            try {
                this.assertElementIsMethod(element);
                LazySQLExec annotation = element.getAnnotation(LazySQLExec.class);
                String sql = this.extractQuery(annotation.value());
                List<Argument> argumentsFromMethod = this.getArgumentsFromStringOrMethod(annotation.params(), element);
                this.checkIfAllArgumentsAreUsed(sql, argumentsFromMethod, element);
                ClassToGenerate tg = this.getClassToGenerate(element, roundEnvironment);
                if (tg.db == null) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Ohne Datenbankverbindung wird die Query nicht weiter gepr\u00fcft.", element);
                } else {
                    try {
                        tg.db.checkSQLSyntax(sql.replaceAll(":", "@"), argumentsFromMethod);
                    }
                    catch (AbstractRDBMSAdapter.NotSupportedException ex) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, ex.getLocalizedMessage(), element);
                    }
                }
                LazyExec lq = new LazyExec();
                lq.methodName = StringUtils.isEmpty((String)annotation.methodName()) ? element.getSimpleName().toString() : annotation.methodName();
                lq.sqlQuery = sql;
                lq.params = argumentsFromMethod;
                lq.element = element;
                lq.annotation = annotation;
                lq.config = tg.config;
                tg.execs.add(lq);
            }
            catch (ElementException | SQLException e) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, e.getLocalizedMessage(), element);
            }
        }
    }

    private ClassToGenerate getClassToGenerate(Element method, RoundEnvironment roundEnvironment) {
        String className;
        if (method.getKind() != ElementKind.METHOD) {
            throw new RuntimeException("Wir k\u00f6nnen nur Methoden und Klassen annotieren bisher....");
        }
        Element clazz = method.getEnclosingElement();
        String packageName = this.elementUtils.getPackageOf(clazz).getQualifiedName().toString();
        String fqcn = packageName + "." + (className = clazz.getSimpleName().toString());
        if (this.toGenerate.containsKey(fqcn)) {
            return this.toGenerate.get(fqcn);
        }
        ClassToGenerate result = new ClassToGenerate();
        result.packageName = packageName;
        result.className = className + "LazyDb";
        result.config = this.findConfig(method, roundEnvironment);
        if (result.config == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Could not find any LazySQL Config. Using default values", method);
            result.config = new DbConfig();
        }
        result.db = this.getDatabaseForElement(method, roundEnvironment, this.messager);
        this.toGenerate.put(fqcn, result);
        return result;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (set.isEmpty()) {
            return false;
        }
        this.processStoredProcedureAnnotations(set, roundEnvironment);
        this.processInsertAnnotations(set, roundEnvironment);
        this.processSelectAnnotations(set, roundEnvironment);
        this.processUpdateAnnotations(set, roundEnvironment);
        this.processExecAnnotations(set, roundEnvironment);
        this.processUpsertAnnotations(set, roundEnvironment);
        try {
            for (ClassToGenerate c : this.toGenerate.values()) {
                this.generateDatabaseClass(c, this.filer);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LazySQLProcessor.class.getName()).log(Level.SEVERE, null, ex);
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "AA" + ex.getLocalizedMessage());
            for (TypeElement typeElement : set) {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, ex.getLocalizedMessage(), typeElement);
            }
        }
        this.toGenerate.clear();
        return true;
    }

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.messager = pe.getMessager();
        this.filer = pe.getFiler();
        this.elementUtils = pe.getElementUtils();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @FunctionalInterface
    public static interface GetClassValue {
        public void execute() throws MirroredTypeException, MirroredTypesException;
    }

    private static class LazySelect {
        String methodName;
        String sqlQuery;
        List<Argument> resultType;
        List<Argument> params;
        Element element;
        LazySQLSelect annotation;
        DbConfig config;

        private LazySelect() {
        }
    }

    private static class LazyUpdate {
        String methodName;
        String sqlQuery;
        List<Argument> params;
        Element element;
        LazySQLUpdate annotation;
        DbConfig config;

        private LazyUpdate() {
        }
    }

    private static class LazyExec {
        String methodName;
        String sqlQuery;
        List<Argument> params;
        Element element;
        LazySQLExec annotation;
        DbConfig config;

        private LazyExec() {
        }
    }

    private static class LazyInsert {
        String methodName;
        String tableName;
        List<Argument> fields;
        Element element;
        LazySQLInsert annotation;
        DbConfig config;

        private LazyInsert() {
        }
    }

    private static class LazyUpsert {
        String methodName;
        String tableName;
        List<Argument> fields;
        List<String> keys;
        List<String> toUpdate;
        Element element;
        LazySQLUpsert annotation;
        DbConfig config;

        private LazyUpsert() {
        }
    }

    private static class LazyProcedure {
        String methodName;
        String procedureName;
        List<Argument> params;
        Element element;
        LazySQLStoredProcedure annotation;
        DbConfig config;

        private LazyProcedure() {
        }
    }

    private static class ClassToGenerate {
        String packageName = "de.thomas_oster";
        String className = "LazyDatabase";
        DbConfig config = null;
        DbQueryTyper db = null;
        List<LazyProcedure> procedures = new LinkedList<LazyProcedure>();
        List<LazyInsert> inserts = new LinkedList<LazyInsert>();
        List<LazyUpsert> upserts = new LinkedList<LazyUpsert>();
        List<LazyUpdate> updates = new LinkedList<LazyUpdate>();
        List<LazySelect> selects = new LinkedList<LazySelect>();
        List<LazyExec> execs = new LinkedList<LazyExec>();

        private ClassToGenerate() {
        }
    }
}

