/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

public class Lazy<T, E extends Throwable> {
    private volatile boolean initalized = false;
    private volatile T value;
    private final Supplier<T, E> load;

    public static <T, E extends Throwable> Lazy<T, E> of(Supplier<T, E> s) {
        return new Lazy<T, E>(s);
    }

    public Lazy(Supplier<T, E> load) {
        this.load = load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws E {
        if (!this.initalized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initalized) {
                    this.value = this.load.get();
                    this.initalized = true;
                }
            }
        }
        return this.value;
    }

    public T getValue() throws E {
        return this.get();
    }

    public synchronized void reset() {
        this.initalized = false;
    }

    public static interface Supplier<T, E extends Throwable> {
        public T get() throws E;
    }
}

