/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.Lazy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ArgumentListCache {
    private final File cachefile;
    private Map<String, ArgumentListOrException> data = new LinkedHashMap<String, ArgumentListOrException>();

    public ArgumentListCache(File cachefile) {
        this.cachefile = cachefile;
        if (cachefile != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.saveToDisk()));
            this.readFromDisk();
        }
    }

    public final void readFromDisk() {
        try (FileInputStream fis = new FileInputStream(this.cachefile);
             ObjectInputStream ois = new ObjectInputStream(fis);){
            Map rdata = (Map)ois.readObject();
            if (rdata != null) {
                for (Map.Entry e : rdata.entrySet()) {
                    ArgumentListOrException d = new ArgumentListOrException();
                    String s = (String)e.getValue();
                    try {
                        if (s.startsWith("SQLEXCEPTION###")) {
                            String[] parts = s.split("###");
                            d.exception = new SQLException(parts[3], parts[2], Integer.parseInt(parts[1]));
                        } else if (s.startsWith("STRINGLIST###")) {
                            d.strings = Arrays.asList(s.substring(13).split(","));
                        } else if (s.startsWith("PROCEDURES###")) {
                            d.procedures = Arrays.stream(s.substring(13).split(",")).map(st -> {
                                AbstractRDBMSAdapter.Procedure p = new AbstractRDBMSAdapter.Procedure();
                                String[] pa = st.split("##");
                                p.name = pa[0];
                                p.comment = "null".equals(pa[1]) ? null : pa[1];
                                return p;
                            }).collect(Collectors.toList());
                        } else {
                            d.list = Argument.fromTypeListString((String)e.getValue());
                        }
                        this.data.put((String)e.getKey(), d);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<AbstractRDBMSAdapter.Procedure> getProcedures(String key, Lazy.Supplier<List<AbstractRDBMSAdapter.Procedure>, Exception> calc) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        ArgumentListOrException d = new ArgumentListOrException();
        if (!this.data.containsKey(key)) {
            try {
                d.procedures = calc.get();
            }
            catch (SQLException e) {
                d.exception = e;
            }
            catch (AbstractRDBMSAdapter.NotSupportedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.data.put(key, d);
        }
        d = this.data.get(key);
        if (d.exception != null) {
            throw d.exception;
        }
        return d.procedures;
    }

    public List<String> getStrings(String key, Lazy.Supplier<List<String>, Exception> calc) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        ArgumentListOrException d = new ArgumentListOrException();
        if (!this.data.containsKey(key)) {
            try {
                d.strings = calc.get();
            }
            catch (SQLException e) {
                d.exception = e;
            }
            catch (AbstractRDBMSAdapter.NotSupportedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.data.put(key, d);
        }
        d = this.data.get(key);
        if (d.exception != null) {
            throw d.exception;
        }
        return d.strings;
    }

    public List<Argument> get(String key, Lazy.Supplier<List<Argument>, Exception> calc) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        ArgumentListOrException d = new ArgumentListOrException();
        if (!this.data.containsKey(key)) {
            try {
                d.list = calc.get();
            }
            catch (SQLException e) {
                d.exception = e;
            }
            catch (AbstractRDBMSAdapter.NotSupportedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.data.put(key, d);
        }
        d = this.data.get(key);
        if (d.exception != null) {
            throw d.exception;
        }
        return d.list;
    }

    public void saveToDisk() {
        LinkedHashMap<String, Object> wdata = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ArgumentListOrException> e : this.data.entrySet()) {
            Object s;
            if (e.getValue().exception != null) {
                SQLException ex = e.getValue().exception;
                s = "SQLEXCEPTION###" + ex.getErrorCode() + "###" + ex.getSQLState() + "###" + ex.getMessage();
            } else {
                s = e.getValue().strings != null ? "STRINGLIST###" + e.getValue().strings.stream().collect(Collectors.joining(",")) : (e.getValue().procedures != null ? "PROCEDURES###" + e.getValue().procedures.stream().map(p -> p.name + "##" + p.comment).collect(Collectors.joining(",")) : Argument.toTypeListString(e.getValue().list));
            }
            wdata.put(e.getKey(), s);
        }
        try (FileOutputStream fos = new FileOutputStream(this.cachefile);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(wdata);
        }
        catch (IOException ex) {
            Logger.getLogger(ArgumentListCache.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static class ArgumentListOrException {
        SQLException exception = null;
        List<Argument> list = null;
        List<String> strings = null;
        List<AbstractRDBMSAdapter.Procedure> procedures = null;

        private ArgumentListOrException() {
        }
    }
}

