/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.shaded_jilt.internal;

import de.thomas_oster.shaded_jilt.Builder;
import de.thomas_oster.shaded_jilt.BuilderInterfaces;
import de.thomas_oster.shaded_jilt.internal.AbstractTypeSafeBuilderGenerator;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.JavaFile;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.MethodSpec;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.TypeName;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

final class TypeSafeBuilderGenerator
extends AbstractTypeSafeBuilderGenerator {
    TypeSafeBuilderGenerator(TypeElement targetClass, List<? extends VariableElement> attributes, Builder builderAnnotation, BuilderInterfaces builderInterfaces, TypeElement targetFactoryClass, Name targetFactoryMethod, Elements elements, Filer filer) {
        super(targetClass, attributes, builderAnnotation, builderInterfaces, targetFactoryClass, targetFactoryMethod, elements, filer);
    }

    @Override
    protected void generateClassesNeededByBuilder() throws Exception {
        TypeSpec.Builder outerInterfacesBuilder = TypeSpec.interfaceBuilder(this.outerInterfacesName()).addAnnotation(this.generatedAnnotation()).addModifiers(Modifier.PUBLIC);
        TypeSpec.Builder optionalsInterfaceBuilder = TypeSpec.interfaceBuilder(this.lastInterfaceName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        for (VariableElement variableElement : this.attributes()) {
            MethodSpec setterMethod = MethodSpec.methodBuilder(this.builderSetterMethodName(variableElement)).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(this.returnTypeForSetterFor(variableElement)).addParameter(TypeName.get(variableElement.asType()), this.attributeSimpleName(variableElement), new Modifier[0]).build();
            if (this.isOptional(variableElement)) {
                optionalsInterfaceBuilder.addMethod(setterMethod);
                continue;
            }
            TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder(this.interfaceNameForAttribute(variableElement)).addModifiers(Modifier.PUBLIC, Modifier.STATIC);
            innerInterfaceBuilder.addMethod(setterMethod);
            outerInterfacesBuilder.addType(innerInterfaceBuilder.build());
        }
        this.addBuildMethodToInterface(optionalsInterfaceBuilder);
        outerInterfacesBuilder.addType(optionalsInterfaceBuilder.build());
        JavaFile javaFile = JavaFile.builder(this.outerInterfacesPackage(), outerInterfacesBuilder.build()).build();
        javaFile.writeTo(this.filer());
    }

    @Override
    protected TypeName builderFactoryMethodReturnType() {
        VariableElement firstRequiredAttribute = this.firstRequiredAttribute();
        String returnTypeName = firstRequiredAttribute == null ? this.lastInterfaceName() : this.interfaceNameForAttribute(firstRequiredAttribute);
        return this.innerInterfaceNamed(returnTypeName);
    }

    @Override
    protected TypeName returnTypeForSetterFor(VariableElement attribute) {
        VariableElement nextRequiredAttribute;
        String returnTypeName = this.isOptional(attribute) ? this.lastInterfaceName() : ((nextRequiredAttribute = this.nextRequiredAttribute(attribute)) == null ? this.lastInterfaceName() : this.interfaceNameForAttribute(nextRequiredAttribute));
        return this.innerInterfaceNamed(returnTypeName);
    }

    @Override
    protected void addSuperInterfaces(TypeSpec.Builder builderClassBuilder) {
        for (VariableElement variableElement : this.attributes()) {
            if (this.isOptional(variableElement)) continue;
            builderClassBuilder.addSuperinterface(this.innerInterfaceNamed(this.interfaceNameForAttribute(variableElement)));
        }
        builderClassBuilder.addSuperinterface(this.innerInterfaceNamed(this.lastInterfaceName()));
    }

    private VariableElement firstRequiredAttribute() {
        VariableElement ret = null;
        if (!this.attributes().isEmpty()) {
            VariableElement firstAttribute = this.attributes().get(0);
            ret = this.isOptional(firstAttribute) ? this.nextRequiredAttribute(firstAttribute) : firstAttribute;
        }
        return ret;
    }

    private VariableElement nextRequiredAttribute(VariableElement attribute) {
        VariableElement ret = attribute;
        while ((ret = this.nextAttribute(ret)) != null && this.isOptional(ret)) {
        }
        return ret;
    }

    @Override
    protected String defaultLastInterfaceName() {
        return "Optionals";
    }
}

