/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.shaded_jilt.internal;

import de.thomas_oster.shaded_jilt.Builder;
import de.thomas_oster.shaded_jilt.BuilderInterfaces;
import de.thomas_oster.shaded_jilt.internal.BuilderGenerator;
import de.thomas_oster.shaded_jilt.internal.ClassicBuilderGenerator;
import de.thomas_oster.shaded_jilt.internal.TypeSafeBuilderGenerator;
import de.thomas_oster.shaded_jilt.internal.TypeSafeUngroupedOptionalsBuilderGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;

public final class BuilderGeneratorFactory {
    private final Filer filer;
    private final Elements elements;

    public BuilderGeneratorFactory(Filer filer, Elements elements) {
        this.filer = filer;
        this.elements = elements;
    }

    public BuilderGenerator forElement(Element annotatedElement) throws Exception {
        List<? extends VariableElement> attributes;
        TypeElement targetClass;
        TypeElement targetFactoryClass = null;
        Name targetFactoryMethod = null;
        ElementKind kind = annotatedElement.getKind();
        if (kind == ElementKind.CLASS) {
            targetClass = (TypeElement)annotatedElement;
            List<? extends Element> enclosedElements = targetClass.getEnclosedElements();
            ArrayList<? extends VariableElement> fields = new ArrayList<VariableElement>(enclosedElements.size());
            for (Element element : enclosedElements) {
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getAnnotation(Builder.Ignore.class) != null) continue;
                fields.add((VariableElement)element);
            }
            attributes = fields;
        } else if (kind == ElementKind.CONSTRUCTOR) {
            targetClass = (TypeElement)annotatedElement.getEnclosingElement();
            ExecutableElement constructor = (ExecutableElement)annotatedElement;
            attributes = constructor.getParameters();
        } else if (kind == ElementKind.METHOD && annotatedElement.getModifiers().contains((Object)Modifier.STATIC)) {
            ExecutableElement method = (ExecutableElement)annotatedElement;
            targetClass = (TypeElement)((DeclaredType)method.getReturnType()).asElement();
            attributes = method.getParameters();
            targetFactoryClass = (TypeElement)method.getEnclosingElement();
            targetFactoryMethod = method.getSimpleName();
        } else {
            throw new IllegalArgumentException("@Builder can only be placed on classes, constructors or static methods");
        }
        Builder builderAnnotation = annotatedElement.getAnnotation(Builder.class);
        BuilderInterfaces builderInterfaces = annotatedElement.getAnnotation(BuilderInterfaces.class);
        switch (builderAnnotation.style()) {
            case TYPE_SAFE: {
                return new TypeSafeBuilderGenerator(targetClass, attributes, builderAnnotation, builderInterfaces, targetFactoryClass, targetFactoryMethod, this.elements, this.filer);
            }
            case TYPE_SAFE_UNGROUPED_OPTIONALS: {
                return new TypeSafeUngroupedOptionalsBuilderGenerator(targetClass, attributes, builderAnnotation, builderInterfaces, targetFactoryClass, targetFactoryMethod, this.elements, this.filer);
            }
        }
        return new ClassicBuilderGenerator(targetClass, attributes, builderAnnotation, targetFactoryClass, targetFactoryMethod, this.elements, this.filer);
    }
}

