/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.shaded_jilt.internal;

import de.thomas_oster.shaded_jilt.Builder;
import de.thomas_oster.shaded_jilt.BuilderInterfaces;
import de.thomas_oster.shaded_jilt.internal.AbstractBuilderGenerator;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.ClassName;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.MethodSpec;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.TypeSpec;
import de.thomas_oster.shaded_jilt.utils.Utils;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

abstract class AbstractTypeSafeBuilderGenerator
extends AbstractBuilderGenerator {
    private final BuilderInterfaces builderInterfaces;

    AbstractTypeSafeBuilderGenerator(TypeElement targetClass, List<? extends VariableElement> attributes, Builder builderAnnotation, BuilderInterfaces builderInterfaces, TypeElement targetFactoryClass, Name targetFactoryMethod, Elements elements, Filer filer) {
        super(targetClass, attributes, builderAnnotation, targetFactoryClass, targetFactoryMethod, elements, filer);
        this.builderInterfaces = builderInterfaces;
    }

    @Override
    protected final void enhance(TypeSpec.Builder builderClassBuilder) {
        this.addSuperInterfaces(builderClassBuilder);
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
    }

    protected abstract void addSuperInterfaces(TypeSpec.Builder var1);

    protected abstract String defaultLastInterfaceName();

    protected final String outerInterfacesName() {
        String nameFromAnnotation = this.builderInterfaces == null ? "" : this.builderInterfaces.outerName();
        return nameFromAnnotation.isEmpty() ? this.targetClassType().getSimpleName() + "Builders" : nameFromAnnotation;
    }

    protected final String outerInterfacesPackage() {
        String packageFromAnnotation = this.builderInterfaces == null ? "" : this.builderInterfaces.packageName();
        return packageFromAnnotation.isEmpty() ? this.builderClassPackage() : packageFromAnnotation;
    }

    protected final String interfaceNameForAttribute(VariableElement attribute) {
        return this.interfaceNameFromBaseName(Utils.capitalize(this.attributeSimpleName(attribute)));
    }

    protected final String lastInterfaceName() {
        String nameFromAnnotation = this.builderInterfaces == null ? "" : this.builderInterfaces.lastInnerName();
        return nameFromAnnotation.isEmpty() ? this.interfaceNameFromBaseName(this.defaultLastInterfaceName()) : nameFromAnnotation;
    }

    protected final void addBuildMethodToInterface(TypeSpec.Builder interfaceBuilder) {
        interfaceBuilder.addMethod(MethodSpec.methodBuilder(this.buildMethodName()).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(this.targetClassTypeName()).build());
    }

    protected final ClassName innerInterfaceNamed(String interfaceName) {
        return ClassName.get(this.outerInterfacesPackage(), this.outerInterfacesName(), interfaceName);
    }

    protected final VariableElement nextAttribute(VariableElement attribute) {
        return this.nextAttribute(this.attributes().indexOf(attribute));
    }

    protected final VariableElement nextAttribute(int index) {
        int i = index + 1;
        return i < this.attributes().size() ? this.attributes().get(i) : null;
    }

    private String interfaceNameFromBaseName(String baseName) {
        String namesPattern = this.builderInterfaces == null ? "" : this.builderInterfaces.innerNames();
        return namesPattern.isEmpty() ? baseName : namesPattern.replaceAll("\\*", baseName);
    }
}

