/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.shaded_jilt.internal;

import de.thomas_oster.shaded_jilt.Builder;
import de.thomas_oster.shaded_jilt.Opt;
import de.thomas_oster.shaded_jilt.internal.BuilderGenerator;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.AnnotationSpec;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.ClassName;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.FieldSpec;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.JavaFile;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.MethodSpec;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.TypeName;
import de.thomas_oster.shaded_jilt.shaded.com.squareup.javapoet.TypeSpec;
import de.thomas_oster.shaded_jilt.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

abstract class AbstractBuilderGenerator
implements BuilderGenerator {
    private final Elements elements;
    private final Filer filer;
    private final TypeElement targetClassType;
    private final List<? extends VariableElement> attributes;
    private final Set<VariableElement> optionalAttributes;
    private final Builder builderAnnotation;
    private final TypeElement targetFactoryClass;
    private final Name targetFactoryMethod;
    private final String builderClassPackage;
    private final ClassName builderClassTypeName;

    AbstractBuilderGenerator(TypeElement targetClass, List<? extends VariableElement> attributes, Builder builderAnnotation, TypeElement targetFactoryClass, Name targetFactoryMethod, Elements elements, Filer filer) {
        this.elements = elements;
        this.filer = filer;
        this.targetClassType = targetClass;
        this.attributes = attributes;
        this.optionalAttributes = this.initOptionalAttributes();
        this.builderAnnotation = builderAnnotation;
        this.targetFactoryClass = targetFactoryClass;
        this.targetFactoryMethod = targetFactoryMethod;
        this.builderClassPackage = this.initBuilderClassPackage();
        this.builderClassTypeName = ClassName.get(this.builderClassPackage(), this.builderClassStringName(), new String[0]);
    }

    @Override
    public final void generateBuilderClass() throws Exception {
        this.generateClassesNeededByBuilder();
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder(this.builderClassTypeName()).addAnnotation(this.generatedAnnotation()).addModifiers(Modifier.PUBLIC);
        builderClassBuilder.addMethod(MethodSpec.methodBuilder(this.builderFactoryMethodName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(this.builderFactoryMethodReturnType()).addStatement("return new $T()", this.builderClassTypeName()).build());
        for (VariableElement variableElement : this.attributes) {
            String fieldName = this.attributeSimpleName(variableElement);
            TypeName fieldType = TypeName.get(variableElement.asType());
            builderClassBuilder.addField(FieldSpec.builder(fieldType, fieldName, Modifier.PRIVATE).build());
            builderClassBuilder.addMethod(MethodSpec.methodBuilder(this.builderSetterMethodName(variableElement)).addModifiers(Modifier.PUBLIC).returns(this.returnTypeForSetterFor(variableElement)).addParameter(fieldType, fieldName, new Modifier[0]).addStatement("this.$1L = $1L", fieldName).addStatement("return this", new Object[0]).build());
        }
        MethodSpec.Builder buildMethod = MethodSpec.methodBuilder(this.buildMethodName()).addModifiers(Modifier.PUBLIC).returns(this.targetClassTypeName());
        String string = Utils.join(this.attributeNames());
        if (this.targetFactoryClass == null) {
            buildMethod.addStatement("return new $T($L)", this.targetClassTypeName(), string);
        } else {
            buildMethod.addStatement("return $T.$L($L)", this.targetFactoryClass, this.targetFactoryMethod, string);
        }
        builderClassBuilder.addMethod(buildMethod.build());
        this.enhance(builderClassBuilder);
        JavaFile javaFile = JavaFile.builder(this.builderClassPackage(), builderClassBuilder.build()).build();
        javaFile.writeTo(this.filer);
    }

    private List<String> attributeNames() {
        ArrayList<String> ret = new ArrayList<String>(this.attributes.size());
        for (VariableElement variableElement : this.attributes) {
            ret.add(this.attributeSimpleName(variableElement));
        }
        return ret;
    }

    protected abstract void generateClassesNeededByBuilder() throws Exception;

    protected abstract TypeName builderFactoryMethodReturnType();

    protected abstract TypeName returnTypeForSetterFor(VariableElement var1);

    protected abstract void enhance(TypeSpec.Builder var1);

    private Set<VariableElement> initOptionalAttributes() {
        HashSet<VariableElement> ret = new HashSet<VariableElement>();
        for (VariableElement variableElement : this.attributes) {
            if (variableElement.getAnnotation(Opt.class) == null) continue;
            ret.add(variableElement);
        }
        return ret;
    }

    private String initBuilderClassPackage() {
        String annotationBuilderPackageName = this.builderAnnotation.packageName();
        if (annotationBuilderPackageName.isEmpty()) {
            PackageElement targetClassPackage = this.elements.getPackageOf(this.targetClassType);
            return targetClassPackage.isUnnamed() ? "" : targetClassPackage.toString();
        }
        return annotationBuilderPackageName;
    }

    private String builderClassStringName() {
        String annotationBuilderClassName = this.builderAnnotation.className();
        return annotationBuilderClassName.isEmpty() ? this.targetClassType.getSimpleName() + "Builder" : annotationBuilderClassName;
    }

    protected final Filer filer() {
        return this.filer;
    }

    protected final TypeElement targetClassType() {
        return this.targetClassType;
    }

    protected final TypeName targetClassTypeName() {
        return TypeName.get(this.targetClassType.asType());
    }

    protected final List<? extends VariableElement> attributes() {
        return this.attributes;
    }

    protected final boolean isOptional(VariableElement attribute) {
        return this.optionalAttributes.contains(attribute);
    }

    protected final String builderClassPackage() {
        return this.builderClassPackage;
    }

    protected final ClassName builderClassTypeName() {
        return this.builderClassTypeName;
    }

    protected final String attributeSimpleName(VariableElement attribute) {
        return attribute.getSimpleName().toString();
    }

    protected final String builderSetterMethodName(VariableElement attribute) {
        String annotationSetterPrefix = this.builderAnnotation.setterPrefix();
        String attributeSimpleName = this.attributeSimpleName(attribute);
        return annotationSetterPrefix.isEmpty() ? attributeSimpleName : annotationSetterPrefix + Utils.capitalize(attributeSimpleName);
    }

    protected final String builderFactoryMethodName() {
        String annotationFactoryMethod = this.builderAnnotation.factoryMethod();
        return annotationFactoryMethod.isEmpty() ? Utils.deCapitalize(this.targetClassType().getSimpleName().toString()) : annotationFactoryMethod;
    }

    protected final String buildMethodName() {
        String annotationBuildMethod = this.builderAnnotation.buildMethod();
        return annotationBuildMethod.isEmpty() ? "build" : annotationBuildMethod;
    }

    protected final AnnotationSpec generatedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", "Jilt-1.1").build();
    }
}

