/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.squareup.javapoet.TypeName;
import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class OracleAdapter
extends AbstractRDBMSAdapter {
    public OracleAdapter() {
        this.tryToLoadDriver("oracle.jdbc.driver.OracleDriver");
    }

    @Override
    public List<Argument> getTableColumns(Connection con, String name, String prefix) throws SQLException {
        return this.getTableColumns(con, con.getCatalog(), null, name, prefix);
    }

    @Override
    public List<AbstractRDBMSAdapter.Procedure> getStoredProcedures(Connection con, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return super.getStoredProcedures(con, con.getCatalog(), null, prefix);
    }

    @Override
    public List<Argument> getStoredProcedureParameters(Connection con, String name) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return super.getStoredProcedureParameters(con, con.getCatalog(), null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Argument> getSqlQueryType(Connection con, String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        if (sql.toLowerCase().replaceAll("\n", " ").contains(" rownum ") || sql.contains(";")) {
            throw new AbstractRDBMSAdapter.NotSupportedException("LayzSQL cannot yet determine the result of this query");
        }
        if (params != null) {
            for (Argument p : params) {
                sql = sql.replaceAll("@" + p.getName(), p.getType().equals((Object)TypeName.get(String.class)) ? "''" : "0");
            }
        } else {
            while (sql.contains("@")) {
                String name = sql.split("@")[1].split("[ )(,]")[0];
                sql = sql.replaceAll("@" + name, "''");
            }
        }
        LinkedList<Argument> a = new LinkedList();
        boolean ac = con.getAutoCommit();
        con.setAutoCommit(false);
        try {
            PreparedStatement s = con.prepareStatement("CREATE TABLE UIT_TMP_VIEW AS " + sql + (sql.toLowerCase().contains("where") ? " AND " : " WHERE ") + "ROWNUM = 0");
            s.execute();
            try {
                a = this.getTableColumns(con, "UIT_TMP_VIEW", null);
            }
            finally {
                con.prepareStatement("DROP TABLE UIT_TMP_VIEW").execute();
            }
        }
        finally {
            con.rollback();
            con.setAutoCommit(ac);
        }
        return a;
    }

    @Override
    public void checkSQLSyntax(Connection con, String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        throw new AbstractRDBMSAdapter.NotSupportedException("Not supported yet.");
    }
}

