/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.gson.Gson;
import de.thomas_oster.lazysql.annotations.LazySQLConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DbConfig {
    public String dburl;
    public String dbuser;
    public String dbpassword;
    public String cachefile;
    public String customDriver;
    public boolean dependencyInjection = false;
    public boolean addJsonAnnotations = false;

    public static DbConfig fromEnvironment() {
        DbConfig result = new DbConfig();
        result.dburl = System.getenv("LAZYSQL_DB");
        result.dbuser = System.getenv("LAZYSQL_DB_USER");
        result.dbpassword = System.getenv("LAZYSQL_DB_PASSWORD");
        result.cachefile = System.getenv("LAZYSQL_CACHEFILE");
        result.customDriver = System.getenv("LAZYSQL_CUSTOMDATABASEDRIVER");
        result.dependencyInjection = Boolean.parseBoolean(System.getenv("LAZYSQL_DEPENDENCYINJECTION"));
        result.addJsonAnnotations = Boolean.parseBoolean(System.getenv("LAZYSQL_ADDJSONANNOTATIONS"));
        return StringUtils.isEmpty((String)result.dburl) ? null : result;
    }

    static File findResourcesDir() {
        return new File(DbConfig.class.getClassLoader().getResource(".").getFile());
    }

    static File findFileInDirOrParents(File dir, String name, int maxSteps) {
        File result = new File(dir, name);
        if (result.exists()) {
            return result;
        }
        return maxSteps > 0 ? DbConfig.findFileInDirOrParents(dir.getParentFile(), name, maxSteps - 1) : null;
    }

    public static DbConfig fromConfigAnnotation(LazySQLConfig cfg) throws ConfigException {
        if (!StringUtils.isEmpty((String)cfg.file())) {
            return DbConfig.fromConfigFile(cfg.file());
        }
        DbConfig result = new DbConfig();
        result.dburl = cfg.dburl();
        result.dbuser = cfg.user();
        result.dbpassword = cfg.password();
        result.cachefile = cfg.cacheFilePath();
        result.customDriver = cfg.customDatabaseDriver();
        result.dependencyInjection = cfg.dependencyInjection();
        result.addJsonAnnotations = cfg.addJsonAnnotations();
        return result;
    }

    public static DbConfig fromSpringBootConfig(String filename) throws ConfigException {
        try {
            File cfgf = new File(filename);
            if (!cfgf.exists()) {
                cfgf = DbConfig.findFileInDirOrParents(DbConfig.findResourcesDir(), filename, 3);
            }
            if (cfgf == null) {
                throw new ConfigException("Cant't find file " + filename + ". I tried " + DbConfig.findResourcesDir().getAbsolutePath() + " and 3 parents");
            }
            DbConfig result = new DbConfig();
            result.addJsonAnnotations = true;
            result.dependencyInjection = true;
            Map cfg = (Map)new YamlReader(FileUtils.readFileToString((File)cfgf, (String)"UTF8")).read();
            if (cfg.get("spring") instanceof Map && ((Map)cfg.get("spring")).get("datasource") instanceof Map) {
                ds = (Map)((Map)cfg.get("spring")).get("datasource");
                result.customDriver = ds.getOrDefault("driverClassName", result.customDriver);
                result.dburl = ds.getOrDefault("url", result.dburl);
                result.dbpassword = ds.getOrDefault("password", result.dbpassword);
                result.dbuser = ds.getOrDefault("username", result.dbuser);
            } else if (cfg.get("spring.datasource") instanceof Map) {
                ds = (Map)cfg.get("spring.datasource");
                result.customDriver = ds.getOrDefault("driverClassName", result.customDriver);
                result.dburl = ds.getOrDefault("url", result.dburl);
                result.dbpassword = ds.getOrDefault("password", result.dbpassword);
                result.dbuser = ds.getOrDefault("username", result.dbuser);
            }
            if (cfg.get("lazysql") != null) {
                Map lcfg = (Map)cfg.get("lazysql");
                result.customDriver = lcfg.getOrDefault("customDriver", result.customDriver);
                result.dbpassword = lcfg.getOrDefault("dbpassword", result.dbpassword);
                result.dburl = lcfg.getOrDefault("dburl", result.dburl);
                result.dbuser = lcfg.getOrDefault("dbuser", result.dbuser);
                result.cachefile = lcfg.getOrDefault("cachefile", result.cachefile);
                result.dependencyInjection = Boolean.parseBoolean((String)((Object)lcfg.getOrDefault("dependencyInjection", "" + result.dependencyInjection)));
                result.addJsonAnnotations = Boolean.parseBoolean((String)((Object)lcfg.getOrDefault("addJsonAnnotations", "" + result.addJsonAnnotations)));
            }
            return StringUtils.isEmpty((String)result.dburl) ? null : result;
        }
        catch (IOException ex) {
            throw new ConfigException(ex);
        }
    }

    public static DbConfig fromConfigFile(String filename) throws ConfigException {
        File cfgf = new File(filename);
        if (!cfgf.exists()) {
            cfgf = DbConfig.findFileInDirOrParents(DbConfig.findResourcesDir(), filename, 3);
        }
        if (cfgf == null) {
            throw new ConfigException("Cant't find file " + filename + ". I tried " + DbConfig.findResourcesDir().getAbsolutePath() + " and 3 parents");
        }
        return DbConfig.fromConfigFile(cfgf);
    }

    public static DbConfig fromConfigFile(File file) throws ConfigException {
        try {
            String json = FileUtils.readFileToString((File)file, (String)"UTF8");
            if (file.getName().toLowerCase().endsWith(".yml")) {
                return (DbConfig)new YamlReader(json.toString()).read(DbConfig.class);
            }
            return (DbConfig)new Gson().fromJson(json.toString(), DbConfig.class);
        }
        catch (IOException ex) {
            throw new ConfigException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbConfig)) {
            return false;
        }
        DbConfig other = (DbConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dependencyInjection != other.dependencyInjection) {
            return false;
        }
        if (this.addJsonAnnotations != other.addJsonAnnotations) {
            return false;
        }
        String this$dburl = this.dburl;
        String other$dburl = other.dburl;
        if (this$dburl == null ? other$dburl != null : !this$dburl.equals(other$dburl)) {
            return false;
        }
        String this$dbuser = this.dbuser;
        String other$dbuser = other.dbuser;
        if (this$dbuser == null ? other$dbuser != null : !this$dbuser.equals(other$dbuser)) {
            return false;
        }
        String this$dbpassword = this.dbpassword;
        String other$dbpassword = other.dbpassword;
        if (this$dbpassword == null ? other$dbpassword != null : !this$dbpassword.equals(other$dbpassword)) {
            return false;
        }
        String this$cachefile = this.cachefile;
        String other$cachefile = other.cachefile;
        if (this$cachefile == null ? other$cachefile != null : !this$cachefile.equals(other$cachefile)) {
            return false;
        }
        String this$customDriver = this.customDriver;
        String other$customDriver = other.customDriver;
        return !(this$customDriver == null ? other$customDriver != null : !this$customDriver.equals(other$customDriver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dependencyInjection ? 79 : 97);
        result = result * 59 + (this.addJsonAnnotations ? 79 : 97);
        String $dburl = this.dburl;
        result = result * 59 + ($dburl == null ? 43 : $dburl.hashCode());
        String $dbuser = this.dbuser;
        result = result * 59 + ($dbuser == null ? 43 : $dbuser.hashCode());
        String $dbpassword = this.dbpassword;
        result = result * 59 + ($dbpassword == null ? 43 : $dbpassword.hashCode());
        String $cachefile = this.cachefile;
        result = result * 59 + ($cachefile == null ? 43 : $cachefile.hashCode());
        String $customDriver = this.customDriver;
        result = result * 59 + ($customDriver == null ? 43 : $customDriver.hashCode());
        return result;
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(Exception ex) {
            super(ex);
        }

        public ConfigException(String message) {
            super(message);
        }
    }
}

