/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import com.squareup.javapoet.TypeName;
import de.thomas_oster.lazysql.ElementException;
import de.thomas_oster.lazysql.TypeHelper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class Argument {
    String name;
    TypeName type;
    Direction dir;

    public Argument(VariableElement v) {
        this(v.getSimpleName().toString(), TypeName.get((TypeMirror)v.asType()), Direction.IN);
    }

    public Argument(String name, Type c) {
        this(name, TypeName.get((Type)c), Direction.IN);
    }

    public Argument(String name, TypeName c) {
        this(name, c, Direction.IN);
    }

    public static List<Argument> fromVariableElements(List<? extends VariableElement> l) {
        return l.stream().map(Argument::new).collect(Collectors.toList());
    }

    static String toArgumentList(List<Argument> params) {
        if (params == null) {
            return "";
        }
        return params.stream().map(Argument::toString).collect(Collectors.joining(", "));
    }

    static void compareWithOrder(List<Argument> a, List<Argument> b) throws MismatchException {
        Iterator<Argument> ia = a.iterator();
        Iterator<Argument> ib = b.iterator();
        while (ia.hasNext() && ib.hasNext()) {
            Argument aa;
            Argument bb = ia.next();
            if (bb.equals(aa = ib.next())) continue;
            throw new MismatchException("Parameters " + aa.getName() + " and " + bb.getName() + " differ. Should be " + Argument.toArgumentList(b));
        }
        if (ia.hasNext()) {
            throw new MismatchException("More parameters in the stored procedure than in the method.Should be " + Argument.toArgumentList(b));
        }
        if (ib.hasNext()) {
            throw new MismatchException("More parameters in the method than in the stored procedure.Should be " + Argument.toArgumentList(b));
        }
    }

    public static void compareWithoutOrder(Collection<Argument> a, Collection<Argument> b) throws MismatchException {
        try {
            Map<String, Argument> mb = b.stream().collect(Collectors.toMap(Argument::getName, x -> x));
            for (Argument ia : a) {
                Argument bb = mb.get(ia.getName());
                if (bb == null) {
                    throw new MismatchException("Parameter " + ia + " is missing");
                }
                if (!bb.getType().equals((Object)ia.getType())) {
                    throw new MismatchException("Parameter " + ia + " has wrong type " + ia.getType() + " instead of " + bb.getType());
                }
                if (bb.getDir().equals((Object)ia.getDir())) continue;
                throw new MismatchException("Parameter " + ia + " has wrong direction " + ia.getDir() + " instead of " + bb.getDir());
            }
            for (Argument ib : b) {
                if (a.contains(ib)) continue;
                throw new MismatchException("Parameter " + ib + " is too much");
            }
        }
        catch (IllegalStateException e) {
            throw new MismatchException(e.getLocalizedMessage());
        }
    }

    public static String toTypeListString(Collection<Argument> type) {
        return type.stream().map(Argument::toString).collect(Collectors.joining(", "));
    }

    public static List<Argument> fromTypeListString(String string) throws ParsingException {
        LinkedList<Argument> result = new LinkedList<Argument>();
        try {
            if (string.isEmpty()) {
                return result;
            }
            for (String part : string.split(", ?")) {
                String[] parts = part.trim().split(" ", 3);
                if (parts.length == 2) {
                    result.add(new Argument(parts[1].trim(), TypeHelper.typeFromString(parts[0].trim())));
                    continue;
                }
                if (parts.length != 3) continue;
                result.add(new Argument(parts[2].trim(), TypeHelper.typeFromString(parts[1].trim()), Direction.valueOf(parts[0])));
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing '" + string + "': " + e.getLocalizedMessage(), e);
        }
        return result;
    }

    public String toString() {
        try {
            return (String)(this.dir == Direction.IN ? "" : this.dir.toString() + " ") + TypeHelper.stringFromType(this.type) + " " + this.name;
        }
        catch (TypeHelper.UnknownTypeException ex) {
            return this.type + " " + this.name;
        }
    }

    public String getName() {
        return this.name;
    }

    public TypeName getType() {
        return this.type;
    }

    public Direction getDir() {
        return this.dir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(TypeName type) {
        this.type = type;
    }

    public void setDir(Direction dir) {
        this.dir = dir;
    }

    public Argument(String name, TypeName type, Direction dir) {
        this.name = name;
        this.type = type;
        this.dir = dir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TypeName this$type = this.getType();
        TypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Direction this$dir = this.getDir();
        Direction other$dir = other.getDir();
        return !(this$dir == null ? other$dir != null : !((Object)((Object)this$dir)).equals((Object)other$dir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Direction $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : ((Object)((Object)$dir)).hashCode());
        return result;
    }

    public static enum Direction {
        IN,
        OUT,
        INOUT;

    }

    public static class MismatchException
    extends ElementException {
        public MismatchException(String message) {
            super(message);
        }
    }

    public static class ParsingException
    extends ElementException {
        public ParsingException(String message, Exception cause) {
            super(message);
        }
    }
}

