/*
 * The MIT License
 *
 * Copyright 2019 Thomas Oster <thomas.oster@upstart-it.de>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package de.thomas_oster.lazysql.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author Thomas Oster (mail@thomas-oster.de)
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
public @interface LazySQLSelect {
    String[] value();
    String[] returns() default "";
    String[] params() default "";
    /**
     * If greater than 0 sets the fetch size
     * @return 
     */
    int fetchSize() default 0;
    /**
     * If set, this class will be generated as return type.
     * If it exists or is generated by other methods also, it's properties
     * will be checked to match. If its not set, a default name will be created
     * as package.CurrentClassLazyDb.Result
     * @return 
     */
    String returnClassName() default "";
    /**
     * If set, this class will not be generated. Useful for manually
     * created classes until we find a better solution
     * @return 
     */
    boolean doNotGenerateClass() default false;
    boolean dynamicWhereClause() default false;
    boolean useObjectAsInput() default false;
    /**
     * If set, the mehtod will not return a list, but the first result or nothing
     * @return 
     */
    boolean returnFirstOrNull() default false;
    String methodName() default "";
}
