/*
 * Decompiled with CFR 0.152.
 */
package omc.ior;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import omc.Global;
import omc.ior.IORNameProvider;

public class ZMQPortFileProvider
implements IORNameProvider {
    public static final String DEFAULT_SUFFIX = "om_local";
    private final String suffix;

    public ZMQPortFileProvider() {
        this(DEFAULT_SUFFIX);
    }

    public ZMQPortFileProvider(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public Optional<String> getSuffix() {
        return Optional.of(this.suffix);
    }

    @Override
    public Path getPath() {
        Path option1 = Global.tmpDir.resolve(String.format("openmodelica.%s.port.%s", Global.username, this.suffix));
        Path option2 = Global.tmpDir.resolve(String.format("openmodelica.%s.nobody.port.%s", Global.username, this.suffix));
        if (Files.exists(option1, new LinkOption[0])) {
            return option1;
        }
        if (Files.exists(option2, new LinkOption[0])) {
            return option2;
        }
        throw new IllegalStateException(String.format("Can't find a omc port file! searched in: [%s,%s]", option1, option2));
    }
}

