/*
 * Decompiled with CFR 0.152.
 */
package omc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import omc.Global;
import omc.OmcExecuter;
import omc.corba.OMCInterface;
import omc.corba.Result;
import omc.ior.IORNameProvider;
import omc.ior.ZMQPortFileProvider;
import org.zeromq.ZMQ;

public class ZeroMQClient
extends OMCInterface {
    private final IORNameProvider portFileProvider;
    private final int ioThreadCnt = 1;
    private final OmcExecuter omcExecutor;
    private ZMQ.Socket socket;
    private ZMQ.Context context;
    private boolean isConnected = false;
    private final Lock socketLock;

    public ZeroMQClient(String omcExec) {
        this(omcExec, ZeroMQClient.findLocale(), new ZMQPortFileProvider());
    }

    public ZeroMQClient(String omcExec, String locale, ZMQPortFileProvider suffixProvider) {
        this.portFileProvider = suffixProvider;
        this.omcExecutor = new OmcExecuter(omcExec, locale);
        this.socketLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result sendExpression(String expression) {
        String response;
        if (!this.isConnected) {
            throw new IllegalStateException("ZMQ-Client not connected!");
        }
        this.socketLock.lock();
        try {
            boolean success = this.socket.send(expression);
            response = this.socket.recvStr().trim();
        }
        finally {
            this.socketLock.unlock();
        }
        this.log.debug("sendExpression: {} returned {}", (Object)expression, (Object)response);
        return new Result(response, this.getError());
    }

    private Optional<String> getError() {
        String erg;
        this.socketLock.lock();
        try {
            boolean success = this.socket.send(GET_ERRORS);
            erg = this.socket.recvStr().trim();
        }
        finally {
            this.socketLock.unlock();
        }
        this.log.debug("receiving errors returned: {}", (Object)erg);
        if (erg.isEmpty() || erg.equals("\"\"")) {
            return Optional.empty();
        }
        if (erg.startsWith("\"") && (erg = erg.substring(1)).endsWith("\"")) {
            erg = erg.substring(0, erg.length() - 1);
        }
        return Optional.of(erg.trim());
    }

    @Override
    public void connect() throws IOException {
        this.omcExecutor.startOmc("--interactive=zmq", "-z=" + this.portFileProvider.getSuffix().get());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.context = ZMQ.context((int)1);
        this.socket = this.context.socket(3);
        this.socket.setLinger(0);
        String portFilecontent = this.readPortFile();
        this.log.debug("port file content: {}", (Object)portFilecontent);
        boolean con = this.socket.connect(portFilecontent);
        this.log.debug("connecting to socket: {}", (Object)con);
        this.isConnected = true;
        this.call("loadModel", "Modelica");
    }

    @Override
    public void disconnect() throws IOException {
        this.socket.close();
        this.context.close();
        this.omcExecutor.shutdown();
        this.isConnected = false;
    }

    private String readPortFile() throws IOException {
        Path path = this.portFileProvider.getPath();
        this.log.debug("reading port file at: {}", (Object)path);
        List<String> lines = Files.readAllLines(path, Global.encoding);
        return lines.get(0);
    }
}

