/*
 * Decompiled with CFR 0.152.
 */
package omc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import omc.Global;
import omc.corba.OMCInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmcExecuter {
    private final String omcExecutable;
    private final String locale;
    private final Logger log;
    private Optional<Process> process = Optional.empty();

    public OmcExecuter(String omcExecutable, String locale) {
        this.omcExecutable = omcExecutable;
        this.locale = locale;
        this.log = LoggerFactory.getLogger(OmcExecuter.class);
    }

    public Process startOmc(String ... arguments) {
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add(this.omcExecutable);
        cmd.addAll(Arrays.asList(arguments));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        env.put(OMCInterface.localeEnvVariable, this.locale);
        env.put("USER", Global.username);
        Path omcWorkingDir = Global.tmpDir.resolve("omc_home-" + UUID.randomUUID().toString());
        Path logFile = omcWorkingDir.resolve("omc.log");
        try {
            Files.createDirectories(omcWorkingDir, new FileAttribute[0]);
            Files.deleteIfExists(logFile);
            Files.createFile(logFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.log.error("Couldn't create working directory or logfile for omc", (Throwable)e);
            throw new IllegalStateException("Couldn't create working directory or logfile for omc");
        }
        pb.directory(omcWorkingDir.toFile());
        pb.redirectErrorStream(true);
        pb.redirectOutput(logFile.toFile());
        try {
            Process process = pb.start();
            this.process = Optional.of(process);
            this.log.info("started {} locale {} - output redirecting to: {}", new Object[]{cmd, this.locale, logFile});
            return process;
        }
        catch (IOException e) {
            this.log.error("Couldn't start {} as subprocess in {}", new Object[]{cmd, omcWorkingDir, e});
            throw new IllegalStateException("couldn't start omc!");
        }
    }

    public void shutdown() {
        this.process.ifPresent(p -> p.destroy());
    }
}

