/*
 * Decompiled with CFR 0.152.
 */
package omc.corba;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import omc.Global;
import omc.corba.parser.ListLexer;
import omc.corba.parser.ListParser;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class ScriptingHelper {
    private static String bckslash = "\\\\";
    private static Pattern extractArrayPattern = Pattern.compile("^\\{+((?:.|\\n)*?)\\}+$");
    private static String arraySplitRegex = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static Pattern pathPattern = Pattern.compile("((?:\\w:)?(((?:\\/|\\\\)[\\w\\-\\.\\s]+)+))");
    private static final String withinRegex = "within\\s+([\\w\\._]+);";
    private static final String modelRegex = "(?:(?:model)|(?:class)|(?:package)|(?:function)|(?:connector))\\s+([\\w\\d_]+)";
    private static final Pattern withinPattern = Pattern.compile("within\\s+([\\w\\._]+);");
    public static final Pattern modelPattern = Pattern.compile("(?:(?:model)|(?:class)|(?:package)|(?:function)|(?:connector))\\s+([\\w\\d_]+)");

    private ScriptingHelper() {
    }

    public static String asString(Object str) {
        return "\"" + str.toString() + "\"";
    }

    public static String asArray(Collection<?> c) {
        return "{" + ScriptingHelper.asParameterList(c) + "}";
    }

    public static String asParameterList(Collection<?> c) {
        if (c.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        c.forEach(x -> sb.append(x.toString() + ", "));
        return sb.substring(0, sb.length() - 2);
    }

    public static String asStringArray(Collection<?> c) {
        List xs = c.stream().map(ScriptingHelper::asString).collect(Collectors.toList());
        return ScriptingHelper.asArray(xs);
    }

    public static String asStringParameterList(Collection<?> c) {
        List xs = c.stream().map(ScriptingHelper::asString).collect(Collectors.toList());
        return ScriptingHelper.asParameterList(xs);
    }

    public static String killTrailingQuotes(String s) {
        if (s.equals("\"\"")) {
            return "";
        }
        return s.trim().replaceAll("^\"|\"$", "");
    }

    public static List<String> fromArray(String modelicaExpr) {
        Matcher matcher = extractArrayPattern.matcher(modelicaExpr);
        matcher.find();
        String extractedArray = matcher.group(1);
        String[] subs = extractedArray.split(arraySplitRegex);
        return subs.length == 0 || extractedArray.isEmpty() ? Collections.emptyList() : Arrays.stream(subs).map(String::trim).collect(Collectors.toList());
    }

    public static List<String> fromNestedArray(String modelicaExpr) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ListParser p = new ListParser((TokenStream)new CommonTokenStream((TokenSource)new ListLexer((CharStream)new ANTLRInputStream((InputStream)new ByteArrayInputStream(modelicaExpr.getBytes())))));
            ListParser.ListContext listContext = p.list();
            if (listContext != null) {
                return ScriptingHelper.fromNestedArray(listContext.listElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static List<String> fromNestedArray(List<ListParser.ListElementContext> list) {
        ArrayList<String> l = new ArrayList<String>();
        for (ListParser.ListElementContext lec : list) {
            if (lec.list() != null) {
                l.addAll(ScriptingHelper.fromNestedArray(lec.list().listElement()));
                continue;
            }
            if (lec.bool() != null) {
                l.add(lec.bool().getText());
                continue;
            }
            if (lec.number() != null) {
                l.add(lec.number().getText());
                continue;
            }
            if (lec.string() != null) {
                l.add(lec.string().getText());
                continue;
            }
            if (lec.path() == null) continue;
            l.add(lec.path().getText());
        }
        return l;
    }

    public static List<Object> fromNestedArrayToNestedList(String modelicaExpr) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            ListParser p = new ListParser((TokenStream)new CommonTokenStream((TokenSource)new ListLexer((CharStream)new ANTLRInputStream((InputStream)new ByteArrayInputStream(modelicaExpr.getBytes())))));
            ListParser.ListContext listContext = p.list();
            if (listContext != null) {
                return ScriptingHelper.fromNestedArrayToNestedList(listContext.listElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static List<Object> fromNestedArrayToNestedList(List<ListParser.ListElementContext> list) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (ListParser.ListElementContext lec : list) {
            if (lec.list() != null) {
                l.add(ScriptingHelper.fromNestedArrayToNestedList(lec.list().listElement()));
                continue;
            }
            if (lec.bool() != null) {
                l.add(lec.bool().getText());
                continue;
            }
            if (lec.number() != null) {
                l.add(lec.number().getText());
                continue;
            }
            if (lec.string() != null) {
                l.add(lec.string().getText().replaceAll("^\\\"|\\\"$", ""));
                continue;
            }
            if (lec.path() == null) continue;
            l.add(lec.path().getText());
        }
        return l;
    }

    public static Optional<String> getModelName(String modelicaCode) {
        Matcher withinMatcher = withinPattern.matcher(modelicaCode);
        Matcher modelMatcher = modelPattern.matcher(modelicaCode);
        String packageName = "";
        if (withinMatcher.find()) {
            packageName = withinMatcher.group(1) + ".";
        }
        if (modelMatcher.find()) {
            String modelName = modelMatcher.group(1);
            return Optional.of(packageName + modelName);
        }
        return Optional.empty();
    }

    public static Optional<String> getModelName(Path file) throws IOException {
        return ScriptingHelper.getModelName(new String(Files.readAllBytes(file), Global.encoding));
    }

    public static Optional<String> extractPath(String str) {
        Matcher pathMatcher = pathPattern.matcher(str);
        if (pathMatcher.find()) {
            String path = pathMatcher.group(1);
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static String convertPath(String path) {
        if (Global.isWindowsOS()) {
            return ScriptingHelper.asString(path.replace("\\", "\\\\"));
        }
        return ScriptingHelper.asString(path);
    }

    public static String convertPath(Path path) {
        return ScriptingHelper.convertPath(path.toString());
    }
}

