/*
 * Decompiled with CFR 0.152.
 */
package omc.corba;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import omc.corba.Result;
import omc.corba.ScriptingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import version.OMVersion;
import version.Version;

public abstract class OMCInterface {
    public static String GET_ERRORS = "getErrorString()";
    public static String fallbackLocale = "en_US.UTF-8";
    public static String localeEnvVariable = "LANG";
    public static final int maxTrys = 2;
    public static final int maxSleep = 3000;
    protected final Logger log;

    public OMCInterface() {
        this.log = LoggerFactory.getLogger(OMCInterface.class);
    }

    public OMCInterface(Logger log) {
        this.log = log;
    }

    public abstract Result sendExpression(String var1);

    public abstract void connect() throws IOException;

    public abstract void disconnect() throws IOException;

    public Result call(String functionName, Object ... args) {
        String params = args.length == 0 ? "()" : "(" + ScriptingHelper.asParameterList(Arrays.asList(args)) + ")";
        String expr = functionName + params;
        Result res = this.sendExpression(expr);
        this.log.debug("calling {} returned: {}", (Object)expr, (Object)res.result);
        return res;
    }

    public boolean is_(String type, String className) {
        String functionName = "is" + type;
        Result res = this.call(functionName, className);
        if (res.error.isPresent()) {
            return false;
        }
        return res.result.equals("true");
    }

    public List<String> getList(String functionName, Object ... args) {
        Result res = this.call(functionName, args);
        if (res.error.isPresent()) {
            return Collections.emptyList();
        }
        return ScriptingHelper.fromArray(res.result);
    }

    public String checkModel(String modelName) {
        Result res = this.call("checkModel", modelName);
        if (res.error.isPresent()) {
            return res.error.get();
        }
        return res.result;
    }

    public String checkAllModelsRecursive(String modelName) {
        Result res = this.call("checkAllModelsRecursive", modelName);
        if (res.error.isPresent()) {
            return res.error.get();
        }
        return res.result;
    }

    public Optional<String> getClassInformation(String className) {
        Result res = this.call("getClassInformation", className);
        return res.error.isPresent() ? Optional.empty() : Optional.of(res.result);
    }

    public Result cd(Path path) {
        return this.call("cd", ScriptingHelper.convertPath(path));
    }

    public Version getVersion() {
        Result res = this.call("getVersion", new Object[0]);
        return new OMVersion(res.result);
    }
}

