/*
 * Decompiled with CFR 0.152.
 */
package omc.corba;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import omc.Global;
import omc.corba.IORNameProvider;
import omc.corba.OMCInterface;
import omc.corba.Result;
import omc.corba.StdIORNameProvider;
import omc.corba.idl.OmcCommunication;
import omc.corba.idl.OmcCommunicationHelper;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;

public class OMCClient
extends OMCInterface {
    private OmcCommunication omc;
    private Optional<ORB> orbOpt = Optional.empty();
    private boolean isConnected;
    private final Optional<String> omcExecutable;
    private Optional<Process> omcProcess = Optional.empty();
    private final String omcLocale;
    private final IORNameProvider iorProvider;

    public OMCClient() {
        this.omcExecutable = Optional.empty();
        this.omcLocale = this.findLocale();
        this.iorProvider = new StdIORNameProvider();
    }

    public OMCClient(String omcExec) {
        this.omcExecutable = Optional.of(omcExec);
        this.omcLocale = this.findLocale();
        this.iorProvider = new StdIORNameProvider();
    }

    public OMCClient(Path omcExec) {
        this(omcExec.toString());
    }

    public OMCClient(Path omcExec, String locale) {
        this(omcExec.toString(), locale);
    }

    public OMCClient(String omcExec, String locale) {
        this.omcExecutable = Optional.of(omcExec);
        this.omcLocale = locale;
        this.iorProvider = new StdIORNameProvider();
    }

    public OMCClient(String omcExec, IORNameProvider iorProvider) {
        this.omcExecutable = Optional.of(omcExec);
        this.omcLocale = this.findLocale();
        this.iorProvider = iorProvider;
    }

    public OMCClient(String omcExec, String locale, IORNameProvider iorProvider) {
        this.omcExecutable = Optional.of(omcExec);
        this.omcLocale = locale;
        this.iorProvider = iorProvider;
    }

    private String findLocale() {
        String systemLang = System.getenv("LANG");
        if (systemLang != null) {
            return systemLang;
        }
        this.log.warn("environment variable `LANG` undefined; using fallback locale: {}", (Object)fallbackLocale);
        return fallbackLocale;
    }

    @Override
    public Result sendExpression(String expression) {
        if (!this.isConnected) {
            throw new IllegalStateException("Client not connected! Connect first!");
        }
        String erg = this.omc.sendExpression(expression).trim();
        return new Result(erg, this.getError());
    }

    @Override
    public void connect() throws IOException, ConnectException {
        this.connectImpl(0);
        this.call("loadModel", "Modelica");
    }

    private void connectImpl(int tryCnt) throws FileNotFoundException, IOException {
        if (tryCnt < 2) {
            try {
                this.omc = this.createOmcConnection();
                this.omc.sendExpression("model t end t;");
                this.isConnected = true;
                this.log.debug("connected");
            }
            catch (FileNotFoundException | COMM_FAILURE e) {
                if (this.omcExecutable.isPresent()) {
                    this.log.debug("Couldn't connect to omc; try starting omc-subprocess");
                    this.omcProcess = Optional.of(this.startOMC());
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.connectImpl(tryCnt + 1);
                }
                this.log.error("Couldn't connect to omc. Start omc as subprocess is disabled!");
                throw new ConnectException("Couldn't connect to omc!");
            }
        } else {
            this.log.error("Couldn't connect to omc after {} attempts", (Object)tryCnt);
            throw new ConnectException("Couldn't connect to omc!");
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.omc._release();
        this.orbOpt.ifPresent(orb -> {
            orb.shutdown(true);
            orb.destroy();
            this.log.debug("killed ORB");
        });
        this.omcProcess.ifPresent(p -> {
            p.destroy();
            this.log.debug("killed omc subprocess");
        });
        this.isConnected = false;
    }

    private OmcCommunication createOmcConnection() throws IOException, FileNotFoundException {
        Path refPath = this.iorProvider.getPath();
        if (Files.exists(refPath, new LinkOption[0])) {
            String stringifiedRef = this.readObjectReference(refPath);
            return this.convertToObject(stringifiedRef);
        }
        throw new FileNotFoundException("Couldn't find " + refPath);
    }

    public Optional<String> getError() {
        String erg = this.omc.sendExpression(GET_ERRORS).trim();
        if (erg.isEmpty() || erg.equals("\"\"")) {
            return Optional.empty();
        }
        if (erg.startsWith("\"") && (erg = erg.substring(1)).endsWith("\"")) {
            erg = erg.substring(0, erg.length() - 1);
        }
        return Optional.of(erg.trim());
    }

    OmcCommunication convertToObject(String stringifiedObject) {
        String[] args = new String[1];
        ORB orb = ORB.init((String[])args, null);
        this.orbOpt = Optional.of(orb);
        return OmcCommunicationHelper.narrow(orb.string_to_object(stringifiedObject));
    }

    String readObjectReference(Path pathToObjRef) throws IOException {
        String head = Files.readAllLines(pathToObjRef).get(0);
        this.log.debug("Read CORBA-Reference from {}", (Object)pathToObjRef);
        return head;
    }

    @Deprecated
    Path getObjectReferencePath() {
        return this.iorProvider.getPath();
    }

    private Process startOMC() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.omcExecutable.get());
        cmd.add("+d=interactiveCorba");
        this.iorProvider.getSuffix().ifPresent(s -> cmd.add("--corbaSessionName=" + s));
        if (!this.omcExecutable.isPresent()) {
            throw new IllegalStateException("unknown omc executable!");
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        env.put(localeEnvVariable, this.omcLocale);
        Path omcWorkingDir = Global.tmpDir.resolve("omc_home");
        Path logFile = omcWorkingDir.resolve("omc.log");
        try {
            Files.createDirectories(omcWorkingDir, new FileAttribute[0]);
            Files.deleteIfExists(logFile);
            Files.createFile(logFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.log.error("Couldn't create working directory or logfile for omc", (Throwable)e);
            throw new IllegalStateException("Couldn't create working directory or logfile for omc");
        }
        pb.directory(omcWorkingDir.toFile());
        pb.redirectErrorStream(true);
        pb.redirectOutput(logFile.toFile());
        try {
            Process process = pb.start();
            this.log.info("started {} {} - locale {} - output redirecting to: {}", new Object[]{this.omcExecutable.get(), cmd, this.omcLocale, logFile});
            return process;
        }
        catch (IOException e) {
            this.log.error("Couldn't start {} {} as subprocess in {}", new Object[]{this.omcExecutable.get(), cmd, omcWorkingDir, e});
            throw new IllegalStateException("couldn't start omc!");
        }
    }
}

