/*
 * Decompiled with CFR 0.152.
 */
package omc.corba;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import omc.corba.IORNameProvider;
import omc.corba.StdIORNameProvider;

public class CustomIORNameProvider
implements IORNameProvider {
    private final String suffix;
    private final boolean unique;
    private final IORNameProvider stdProvider = new StdIORNameProvider();
    private final Path iorPath;

    public CustomIORNameProvider(String suffix, boolean unique) {
        this.unique = unique;
        this.suffix = this.createUniqueName(this.stdProvider.getPath(), "." + suffix);
        this.iorPath = Paths.get(this.stdProvider.getPath().toString() + this.suffix, new String[0]);
    }

    private String createUniqueName(Path startPath, String suffix) {
        String suffixPath = startPath.toString();
        if (this.unique) {
            int cnt = 2;
            String uniqueSuffix = suffix;
            while (Files.exists(Paths.get(suffixPath + uniqueSuffix, new String[0]), new LinkOption[0])) {
                uniqueSuffix = suffix + "-" + cnt;
                ++cnt;
            }
            return uniqueSuffix;
        }
        return suffix;
    }

    @Override
    public Path getPath() {
        return this.iorPath;
    }

    @Override
    public Optional<String> getSuffix() {
        return Optional.of(this.suffix.substring(1));
    }
}

