/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ServletUtils {
    public static String getHttpParamsAsString(HttpServletRequest request) {
        ArrayList<String> paramList = new ArrayList<String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramKey = (String)paramNames.nextElement();
            String paramValue = request.getParameter(paramKey);
            paramList.add(String.format("'%s'='%s'", paramKey, paramValue));
        }
        return StringUtils.join(paramList, (String)",");
    }

    public static String getHttpHeadersAsString(HttpServletRequest request) {
        ArrayList<String> headerList = new ArrayList<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String headerKey = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerKey);
            headerList.add(String.format("'%s'='%s'", headerKey, headerValue));
        }
        return StringUtils.join(headerList, (String)",");
    }

    public static String getHttpCookiesAsString(HttpServletRequest request) {
        ArrayList<String> cookieList = new ArrayList<String>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieList.add(ToStringBuilder.reflectionToString((Object)cookie));
            }
            return StringUtils.join(cookieList, (String)",");
        }
        return "";
    }
}

