/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.crypto;

import de.thksystems.util.crypto.CryptoRuntimeException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public final class PasswordUtils {
    public static final String DEFAULT_PASSWORD_HASHALGO = "SHA-256";

    private PasswordUtils() {
    }

    public static String createPasswordHash(String plainPassword, String hashAlgo) throws NoSuchAlgorithmException {
        if (plainPassword == null || plainPassword.length() == 0) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance(DEFAULT_PASSWORD_HASHALGO);
        byte[] digest = md.digest(plainPassword.getBytes());
        byte[] digestHex = Hex.encode((byte[])digest);
        return new String(digestHex);
    }

    public static String createPasswordHash(String plainPassword) {
        try {
            return PasswordUtils.createPasswordHash(plainPassword, DEFAULT_PASSWORD_HASHALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static String encryptAsPassword(String password) {
        if (password == null || password.length() == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(DEFAULT_PASSWORD_HASHALGO);
            byte[] digest = md.digest(password.getBytes());
            String encryptedPassword = new String(Base64.encode((byte[])digest));
            return encryptedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }
}

