/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.crypto;

import de.thksystems.util.crypto.CryptoException;
import de.thksystems.util.crypto.CryptoRuntimeException;
import de.thksystems.util.crypto.EncryptionContainer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class EncryptionUtils {
    private static final String ALGORITHM = "AES";
    private static final String TEXT_ENCODING = "UTF-8";
    private static final int KEYSIZE = 256;
    private static final int ITERATIONS = 65536;
    private static final byte[] SALT = new byte[]{119, 79, 88, 32, -87, 91, 56, -23, 70, -78, -69, 4, -35, 20, -71, -39};
    private static boolean init;
    private static SecretKeyFactory skf;

    private EncryptionUtils() {
    }

    private static void lazyInit() {
        try {
            if (!init) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                init = true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static EncryptionContainer encryptString(String passphrase, String text) throws CryptoException {
        try {
            return EncryptionUtils.encryptData(passphrase, text.getBytes(TEXT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    public static EncryptionContainer encryptData(String passphrase, byte[] data) throws CryptoException {
        EncryptionUtils.lazyInit();
        try {
            SecretKey secret = EncryptionUtils.getSecretKey(passphrase);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = cipher.doFinal(data);
            return new EncryptionContainer(iv, ciphertext);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    public static String decryptToString(String passphrase, EncryptionContainer er) throws CryptoException {
        return EncryptionUtils.decryptToString(passphrase, er.getData(), er.getIv());
    }

    public static String decryptToString(String passphrase, byte[] data, byte[] iv) throws CryptoException {
        EncryptionUtils.lazyInit();
        try {
            SecretKey secret = EncryptionUtils.getSecretKey(passphrase);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return new String(cipher.doFinal(data), TEXT_ENCODING);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Decryption failed", e);
        }
    }

    private static SecretKey getSecretKey(String passphrase) throws InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), SALT, 65536, 256);
        SecretKey tmp = skf.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), ALGORITHM);
        return secret;
    }

    public static void encryptToFile(File file, String text, String passphrase) throws CryptoException, IOException {
        EncryptionContainer ec = EncryptionUtils.encryptString(passphrase, text);
        ec.writeToFile(file);
    }

    public static String decryptFromFile(File file, String passphrase) throws CryptoException, IOException {
        EncryptionContainer ec = EncryptionContainer.readFromFile(file);
        return EncryptionUtils.decryptToString(passphrase, ec);
    }
}

