/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class EncryptionContainer {
    private static final int IV_LENGTH = 16;
    private byte[] data;
    private byte[] iv;

    private EncryptionContainer() {
    }

    EncryptionContainer(byte[] iv, byte[] data) {
        this.data = data;
        this.iv = iv;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public void writeToFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(this.getData());
        fos.write(this.iv);
        fos.close();
    }

    public static EncryptionContainer readFromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        int fileLength = new Long(file.length()).intValue();
        byte[] data = new byte[fileLength - 16];
        byte[] iv = new byte[16];
        fis.read(data);
        fis.read(iv);
        fis.close();
        return new EncryptionContainer(iv, data);
    }
}

