/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.persistence.spring;

import de.thksystems.exception.ServiceRuntimeException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseService.class);
    @Autowired
    private PlatformTransactionManager transactionManager;

    protected <T> T throwAsServiceRuntimeExceptionAndLog(Throwable cause, String message) {
        String msg = message + ": " + cause.toString();
        LOG.error(msg, cause);
        throw new ServiceRuntimeException(msg, cause);
    }

    protected TransactionStatus startTransaction(boolean readonly) {
        LOG.trace("Starting new transaction");
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(readonly);
        return this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
    }

    protected TransactionStatus startTransaction() {
        return this.startTransaction(false);
    }

    protected TransactionStatus startTransactionIfRequired(TransactionStatus transactionStatus) {
        if (transactionStatus == null || transactionStatus.isCompleted()) {
            return this.startTransaction();
        }
        return transactionStatus;
    }

    protected void commitTransaction(TransactionStatus transactionStatus) {
        if (transactionStatus != null && !transactionStatus.isCompleted()) {
            LOG.trace("Committing transaction");
            this.transactionManager.commit(transactionStatus);
        }
    }

    protected void rollbackTransaction(TransactionStatus transactionStatus) {
        if (transactionStatus != null && !transactionStatus.isCompleted()) {
            LOG.trace("Rollback transaction");
            this.transactionManager.rollback(transactionStatus);
        }
    }

    protected boolean enableScheduling() {
        return !this.isJUnitTest();
    }

    private boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }
}

