/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.persistence.hibernate;

import java.io.Serializable;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.ClassUtils;

@MappedSuperclass
public abstract class IdentifiedEntity
implements Serializable {
    private static final long serialVersionUID = 5968828150324034087L;
    @Id
    @GeneratedValue
    private long id;

    public Long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return ClassUtils.getAbbreviatedName(this.getClass(), (int)20) + ": " + this.toStringIdentifier();
    }

    protected String toStringIdentifier() {
        return "ID: " + (this.getId() == null ? "(new)" : String.valueOf(this.getId()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentifiedEntity)) {
            return false;
        }
        if (((IdentifiedEntity)obj).getId() == null || this.getId() == null) {
            return false;
        }
        return obj.getClass() == this.getClass() && ((IdentifiedEntity)obj).getId().longValue() == this.getId().longValue();
    }
}

