/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.persistence.hibernate;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRepository<E extends Serializable> {
    static final Logger LOG = LoggerFactory.getLogger(BaseRepository.class);
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    protected Class<E> entityType;

    public BaseRepository() {
        java.lang.reflect.Type type = this.getClass().getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != BaseRepository.class) {
            if (type instanceof ParameterizedType) {
                type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                continue;
            }
            type = ((Class)type).getGenericSuperclass();
        }
        this.entityType = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }

    final Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    Class<E> getEntityType() {
        return this.entityType;
    }

    public void flush() {
        this.getCurrentSession().flush();
    }

    public void create(E object) {
        this.getCurrentSession().save(object);
    }

    public void createOrUpdate(E object) {
        this.getCurrentSession().saveOrUpdate(object);
    }

    private Criteria distinctCriteria() {
        return this.getCurrentSession().createCriteria(this.getEntityType()).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
    }

    private Criteria criteriaWithCriterions(Criterion ... criterions) {
        Criteria criteria = this.distinctCriteria();
        for (Criterion criterion : criterions) {
            criteria.add(criterion);
        }
        return criteria;
    }

    public E findById(long id) {
        return (E)((Serializable)this.getCurrentSession().get(this.getEntityType(), (Serializable)Long.valueOf(id)));
    }

    protected List<E> queryByIds(List<Long> list) {
        return this.query((E)new Criterion[]{Restrictions.in((String)"id", list)});
    }

    public List<E> queryAll() {
        return this.queryAll(new Order[0]);
    }

    public List<E> queryAll(Order ... orders) {
        Criteria criteria = this.distinctCriteria();
        for (Order order : orders) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    protected E find(Criterion ... criterions) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.criteriaWithCriterions(criterions);
        Serializable result = (Serializable)criteria.uniqueResult();
        LOG.trace("Find for {} by {}. Runtime: {}", new Object[]{this.getEntityType(), criterions, System.currentTimeMillis() - startTime});
        return (E)result;
    }

    protected List<E> query(Criterion ... criterions) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.criteriaWithCriterions(criterions);
        List list = criteria.list();
        LOG.trace("Query for {} by {}. Runtime: {}", new Object[]{this.getEntityType(), criterions, System.currentTimeMillis() - startTime});
        return list;
    }

    protected List<E> query(Order order, Criterion ... criterions) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.criteriaWithCriterions(criterions);
        criteria.addOrder(order);
        List list = criteria.list();
        LOG.trace("Query for {} by {} order {}. Runtime: {}", new Object[]{this.getEntityType(), criterions, order, System.currentTimeMillis() - startTime});
        return list;
    }

    protected E find(CriteriaModifier cm) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.distinctCriteria();
        cm.modify(criteria);
        Serializable result = (Serializable)criteria.uniqueResult();
        LOG.trace("Find for {} by {}. Runtime: {}", new Object[]{this.getEntityType(), criteria, System.currentTimeMillis() - startTime});
        return (E)result;
    }

    protected List<E> query(CriteriaModifier cm) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.distinctCriteria();
        cm.modify(criteria);
        List list = criteria.list();
        LOG.trace("Query for {} by {}. Runtime: {}", new Object[]{this.getEntityType(), criteria, System.currentTimeMillis() - startTime});
        return list;
    }

    protected E find(E example) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.distinctCriteria();
        Serializable result = (Serializable)criteria.add((Criterion)Example.create(example)).uniqueResult();
        LOG.trace("Find for {} by {} (example). Runtime: {}", new Object[]{this.getEntityType(), criteria, System.currentTimeMillis() - startTime});
        return (E)result;
    }

    protected List<E> query(E example) {
        long startTime = System.currentTimeMillis();
        Criteria criteria = this.distinctCriteria();
        List list = criteria.add((Criterion)Example.create(example)).list();
        LOG.trace("Query for {} by {} (example). Runtime: {}", new Object[]{this.getEntityType(), criteria, System.currentTimeMillis() - startTime});
        return list;
    }

    protected E findBySqlUsingId(String sql, Object ... params) {
        long startTime = System.currentTimeMillis();
        SQLQuery sqlQuery = this.createSqlUsingId(sql.toUpperCase(), params);
        long id = (Long)sqlQuery.uniqueResult();
        E result = this.findById(id);
        LOG.trace("Find for {} by '{}'. Runtime: {}", new Object[]{this.getEntityType(), sql, System.currentTimeMillis() - startTime});
        return result;
    }

    protected List<E> queryBySqlUsingId(String sql, Object ... params) {
        long startTime = System.currentTimeMillis();
        SQLQuery sqlQuery = this.createSqlUsingId(sql.toUpperCase(), params);
        List list = sqlQuery.list();
        List<E> resultList = this.queryByIds(list);
        LOG.trace("Query for {} by '{}'. Runtime: {}", new Object[]{this.getEntityType(), sql, System.currentTimeMillis() - startTime});
        return resultList;
    }

    private SQLQuery createSqlUsingId(String sql, Object ... params) {
        SQLQuery sqlQuery = this.getCurrentSession().createSQLQuery(sql).addScalar("id", (Type)LongType.INSTANCE);
        this.setQueryParameter((Query)sqlQuery, params);
        return sqlQuery;
    }

    private void setQueryParameter(Query query, Object ... params) {
        if (params.length == 1 && params[0] instanceof Map) {
            Map paramMap = (Map)params[0];
            for (String key : paramMap.keySet()) {
                query.setParameter(key, paramMap.get(key));
            }
        } else {
            for (int i = 0; params != null && i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
    }

    protected E findByHql(String hql, Object ... params) {
        long startTime = System.currentTimeMillis();
        Query hqlQuery = this.createHql(hql, params);
        Serializable result = (Serializable)hqlQuery.uniqueResult();
        LOG.trace("Find for {} by '{}'. Runtime: {}", new Object[]{this.getEntityType(), hql, System.currentTimeMillis() - startTime});
        return (E)result;
    }

    protected List<E> queryByHql(String hql, Object ... params) {
        long startTime = System.currentTimeMillis();
        Query hqlQuery = this.createHql(hql, params);
        List list = hqlQuery.list();
        LOG.trace("Query for {} by '{}'. Runtime: {}", new Object[]{this.getEntityType(), hql, System.currentTimeMillis() - startTime});
        return list;
    }

    protected int executeUpdatebyHql(String hql, Object ... params) {
        long startTime = System.currentTimeMillis();
        Query hqlQuery = this.createHql(hql, params);
        int count = hqlQuery.executeUpdate();
        LOG.trace("Execute update of {} by '{}'. Runtime: {}", new Object[]{this.getEntityType(), hql, System.currentTimeMillis() - startTime});
        return count;
    }

    protected Query createHql(String hql, Object ... params) {
        Query hqlQuery = this.getCurrentSession().createQuery(hql);
        this.setQueryParameter(hqlQuery, params);
        return hqlQuery;
    }

    protected static interface CriteriaModifier {
        public void modify(Criteria var1);
    }
}

