/*
 * tksCommons
 * 
 * Author : Thomas Kuhlmann (ThK-Systems, http://www.thk-systems.de) License : LGPL (https://www.gnu.org/licenses/lgpl.html)
 */

package de.thksystems.util.servlet;

import java.util.ArrayList;
import java.util.Enumeration;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ServletUtils {

	/**
	 * Get http params as comma-separated string-list.
	 */
	public static String getHttpParamsAsString(HttpServletRequest request) {
		ArrayList<String> paramList = new ArrayList<>();
		Enumeration<String> paramNames = request.getParameterNames();
		while (paramNames != null && paramNames.hasMoreElements()) {
			String paramKey = paramNames.nextElement();
			String paramValue = request.getParameter(paramKey);
			paramList.add(String.format("'%s'='%s'", paramKey, paramValue));
		}
		return StringUtils.join(paramList, ",");
	}

	/**
	 * Get http headers as comma-separated string-list.
	 */
	public static String getHttpHeadersAsString(HttpServletRequest request) {
		ArrayList<String> headerList = new ArrayList<>();
		Enumeration<String> headerNames = request.getHeaderNames();
		while (headerNames != null && headerNames.hasMoreElements()) {
			String headerKey = headerNames.nextElement();
			String headerValue = request.getHeader(headerKey);
			headerList.add(String.format("'%s'='%s'", headerKey, headerValue));
		}
		return StringUtils.join(headerList, ",");
	}

	/**
	 * Get http cookies as comma-separated string-list.
	 */
	public static String getHttpCookiesAsString(HttpServletRequest request) {
		ArrayList<String> cookieList = new ArrayList<>();
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				cookieList.add(ToStringBuilder.reflectionToString(cookie));
			}
			return StringUtils.join(cookieList, ",");
		} else {
			return "";
		}
	}
}
