/*
 * tksCommons
 * 
 * Author  : Thomas Kuhlmann (ThK-Systems, http://www.thk-systems.de)
 * License : LGPL (https://www.gnu.org/licenses/lgpl.html)
 */
package de.thksystems.util.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * Holds ecrypted data.
 * 
 * @see EncryptionUtils
 */
public final class EncryptionContainer {

	private static final int IV_LENGTH = 16;

	private byte[] data;
	private byte[] iv;

	@SuppressWarnings("unused")
	private EncryptionContainer() {
	}

	EncryptionContainer(byte[] iv, byte[] data) {
		super();
		this.data = data;
		this.iv = iv;
	}

	public byte[] getData() {
		return data;
	}

	public byte[] getIv() {
		return iv;
	}

	public void writeToFile(File file) throws IOException {
		FileOutputStream fos = new FileOutputStream(file);
		fos.write(getData());
		fos.write(iv);
		fos.close();
	}

	public static EncryptionContainer readFromFile(File file) throws IOException {
		FileInputStream fis = new FileInputStream(file);
		int fileLength = new Long(file.length()).intValue();
		byte[] data = new byte[fileLength - IV_LENGTH];
		byte[] iv = new byte[IV_LENGTH];
		fis.read(data);
		fis.read(iv);
		fis.close();
		return new EncryptionContainer(iv, data);
	}
}
