package de.thksystems.persistence.hibernate;

import java.io.Serializable;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.apache.commons.lang3.ClassUtils;

/**
 * Identified entities have an ID, can be compared to each other and have a toString() method.
 */
@MappedSuperclass
public abstract class IdentifiedEntity implements Serializable {

	private static final long serialVersionUID = 5968828150324034087L;

	@Id
	@GeneratedValue
	private long id;

	public Long getId() {
		return id;
	}

	protected void setId(long id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return ClassUtils.getAbbreviatedName(getClass(), 20) + ": " + toStringIdentifier();
	}

	/** Unique identifier of object. */
	protected String toStringIdentifier() {
		return "ID: " + (getId() == null ? "(new)" : String.valueOf(getId()));
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof IdentifiedEntity)) {
			return false;
		}
		if (((IdentifiedEntity) obj).getId() == null || this.getId() == null) {
			return false;
		}
		return (obj.getClass() == this.getClass() && ((IdentifiedEntity) obj).getId().longValue() == this.getId().longValue());
	}

}