/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.xml;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomUtils {
    private DomUtils() {
    }

    public static List<Node> getNodeTreeAsList(Node node) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        DomUtils.addNodeRecursivelyToList(node, nodeList);
        return nodeList;
    }

    private static void addNodeRecursivelyToList(Node node, List<Node> nodeList) {
        nodeList.add(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            DomUtils.addNodeRecursivelyToList(children.item(i), nodeList);
            ++i;
        }
    }

    public static String nodeToString(Node node, boolean omitXmlDeclaration, String encoding) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("encoding", "UTF-8");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            throw new IllegalArgumentException(te);
        }
        return sw.toString();
    }

    public static String nodeToString(Node node) {
        return DomUtils.nodeToString(node, false, StandardCharsets.UTF_8.name());
    }

    public static Element createAndAddElement(Node parentNode, String nodeName) {
        Document doc = DomUtils.getOwningDocument(parentNode);
        Element newElem = doc.createElement(nodeName);
        parentNode.appendChild(newElem);
        return newElem;
    }

    public static Document getOwningDocument(Node parentNode) {
        if (parentNode instanceof Document) {
            return (Document)parentNode;
        }
        return parentNode.getOwnerDocument();
    }

    public static Attr createAndAddAttribute(Node parentNode, String attrName, String attrValue) {
        Document doc = DomUtils.getOwningDocument(parentNode);
        Attr attr = doc.createAttribute(attrName);
        attr.setValue(attrValue);
        parentNode.getAttributes().setNamedItem(attr);
        return attr;
    }

    public static Text createAndAddTextNode(Node parentNode, String text) {
        Document doc = DomUtils.getOwningDocument(parentNode);
        Text textNode = doc.createTextNode(text);
        parentNode.appendChild(textNode);
        return textNode;
    }
}

