/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.text;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParseUtils {
    public static final BigDecimal VALUE_BIGDECIMAL_MINUSONE = new BigDecimal("-1");
    private static final Pattern FILESIZE_PATTERN = Pattern.compile("^([0-9.]+)([ETGMK]B?)$", 2);
    private static Map<String, Integer> fileSizePowMap = null;

    private ParseUtils() {
    }

    public static BigDecimal parseFileSize(String filesize) {
        BigDecimal value;
        block5: {
            if (filesize == null || filesize.length() == 0) {
                return null;
            }
            Matcher matcher = FILESIZE_PATTERN.matcher(filesize);
            if (matcher.find()) {
                String number = matcher.group(1);
                int pow = ParseUtils.getFileSizePowMap().get(matcher.group(2).toUpperCase());
                BigDecimal bytes = new BigDecimal(number);
                bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
                return bytes;
            }
            try {
                value = new BigDecimal(filesize);
                if (value.compareTo(VALUE_BIGDECIMAL_MINUSONE) > 0) break block5;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return value;
    }

    private static Map<String, Integer> getFileSizePowMap() {
        if (fileSizePowMap == null) {
            fileSizePowMap = new HashMap<String, Integer>();
            fileSizePowMap.put("EB", 5);
            fileSizePowMap.put("TB", 4);
            fileSizePowMap.put("GB", 3);
            fileSizePowMap.put("MB", 2);
            fileSizePowMap.put("KB", 1);
            fileSizePowMap.put("E", 5);
            fileSizePowMap.put("T", 4);
            fileSizePowMap.put("G", 3);
            fileSizePowMap.put("M", 2);
            fileSizePowMap.put("K", 1);
        }
        return fileSizePowMap;
    }
}

