package de.thksystems.util.reflection;

/*
 * tksCommons
 * 
 * Author  : Thomas Kuhlmann (ThK-Systems, http://www.thk-systems.de)
 * License : LGPL (https://www.gnu.org/licenses/lgpl.html)
 */

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * Reflection-Helper.
 */
public final class ReflectionUtils {

	private ReflectionUtils() {
	}

	/**
	 * Gets all fields from a class including the fields from all its super-classes.
	 */
	public static List<Field> getAllFields(Class<?> type) {
		List<Field> fieldList = new ArrayList<>();
		getAllFields(fieldList, type);
		return fieldList;
	}

	private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
		for (Field field : type.getDeclaredFields()) {
			fields.add(field);
		}
		if (type.getSuperclass() != null) {
			fields = getAllFields(fields, type.getSuperclass());
		}
		return fields;
	}

}
