/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.text;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParseUtils {
    private static final Pattern FILESIZE_PATTERN = Pattern.compile("^([0-9.]+)([ETGMK]B?)$", 2);
    private static final Map<String, Integer> FILESIZE_POWMAP = new HashMap<String, Integer>();

    private ParseUtils() {
    }

    public static BigDecimal parseFileSize(String filesize) {
        if (filesize == null || filesize.length() == 0) {
            return null;
        }
        Matcher matcher = FILESIZE_PATTERN.matcher(filesize);
        if (matcher.find()) {
            String number = matcher.group(1);
            int pow = FILESIZE_POWMAP.get(matcher.group(2).toUpperCase());
            BigDecimal bytes = new BigDecimal(number);
            bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
            return bytes;
        }
        try {
            return new BigDecimal(filesize);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(-1);
        }
    }

    static {
        FILESIZE_POWMAP.put("EB", 5);
        FILESIZE_POWMAP.put("TB", 4);
        FILESIZE_POWMAP.put("GB", 3);
        FILESIZE_POWMAP.put("MB", 2);
        FILESIZE_POWMAP.put("KB", 1);
        FILESIZE_POWMAP.put("E", 5);
        FILESIZE_POWMAP.put("T", 4);
        FILESIZE_POWMAP.put("G", 3);
        FILESIZE_POWMAP.put("M", 2);
        FILESIZE_POWMAP.put("K", 1);
    }
}

