/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.xstream.converters;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class MapToAttributesConverter
implements Converter {
    protected static final Class<?> TARGET_CLASS = Map.class;
    private Class<?> valueClass = String.class;
    private Constructor<?> valueClassConstructor;

    public MapToAttributesConverter() {
        this(String.class);
    }

    public MapToAttributesConverter(Class<?> valueClass) {
        if (!TARGET_CLASS.isAssignableFrom(valueClass)) {
            this.valueClass = valueClass;
            this.checkValueClass();
        }
    }

    private void checkValueClass() {
        if (!String.class.isAssignableFrom(this.valueClass)) {
            Class[] parameterTypes = new Class[]{String.class};
            try {
                this.valueClassConstructor = this.valueClass.getConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Value class cannot be converted to string: " + this.valueClass);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Cannot check value class: " + e.getMessage(), e);
            }
        }
    }

    public boolean canConvert(Class type) {
        return TARGET_CLASS.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        for (Map.Entry entry : map.entrySet()) {
            writer.addAttribute((String)entry.getKey(), entry.getValue().toString());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String valueObject;
            String key = reader.getAttributeName(i);
            String valueString = reader.getAttribute(key);
            if (this.valueClassConstructor != null) {
                try {
                    valueObject = this.valueClassConstructor.newInstance(valueString);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new XStreamException(String.format("Cannot convert string value '%s' to class '%s': %s", valueString, this.valueClass, e.getMessage()), (Throwable)e);
                }
            } else {
                valueObject = valueString;
            }
            map.put(key, valueObject);
        }
        return map;
    }
}

