/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.text;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ParseUtils {
    public static final BigDecimal VALUE_BIGDECIMAL_MINUSONE = new BigDecimal("-1");
    private static final Pattern FILESIZE_PATTERN = Pattern.compile("^([0-9.]+)([ETGMK]B?)$", 2);
    private static Map<String, Integer> fileSizePowMap = null;
    private static final Pattern DURATION_PATTERN = Pattern.compile("^([0-9.]+)(ms|s|m|h|d|w|M|y)?$");
    private static Map<String, Long> durationFactorMap = null;

    private ParseUtils() {
    }

    public static BigDecimal parseFileSize(String filesize) {
        if (filesize == null || filesize.length() == 0) {
            return null;
        }
        Matcher matcher = FILESIZE_PATTERN.matcher(filesize);
        if (matcher.find()) {
            String number = matcher.group(1);
            int pow = ParseUtils.getFileSizePowMap().get(matcher.group(2).toUpperCase());
            BigDecimal bytes = new BigDecimal(number);
            bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
            return bytes;
        }
        try {
            BigDecimal value = new BigDecimal(filesize);
            if (value.compareTo(VALUE_BIGDECIMAL_MINUSONE) <= 0) {
                return null;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Map<String, Integer> getFileSizePowMap() {
        if (fileSizePowMap == null) {
            fileSizePowMap = new HashMap<String, Integer>();
            fileSizePowMap.put("EB", 5);
            fileSizePowMap.put("TB", 4);
            fileSizePowMap.put("GB", 3);
            fileSizePowMap.put("MB", 2);
            fileSizePowMap.put("KB", 1);
            fileSizePowMap.put("E", 5);
            fileSizePowMap.put("T", 4);
            fileSizePowMap.put("G", 3);
            fileSizePowMap.put("M", 2);
            fileSizePowMap.put("K", 1);
        }
        return fileSizePowMap;
    }

    public static BigDecimal parseDuration(String durationString) {
        Matcher matcher;
        if (StringUtils.isNotEmpty((CharSequence)durationString) && (matcher = DURATION_PATTERN.matcher(durationString)).find()) {
            BigDecimal value = new BigDecimal(matcher.group(1));
            String unit = matcher.group(2);
            BigDecimal factor = new BigDecimal(ParseUtils.getDurationFactorMap().get(unit));
            return value.multiply(factor);
        }
        return null;
    }

    private static Map<String, Long> getDurationFactorMap() {
        if (durationFactorMap == null) {
            durationFactorMap = new HashMap<String, Long>();
            durationFactorMap.put(null, 1L);
            durationFactorMap.put("ms", 1L);
            durationFactorMap.put("s", 1000L);
            durationFactorMap.put("m", 60000L);
            durationFactorMap.put("h", 3600000L);
            durationFactorMap.put("d", 86400000L);
            durationFactorMap.put("w", 604800000L);
            durationFactorMap.put("M", 2592000000L);
            durationFactorMap.put("y", 31536000000L);
        }
        return durationFactorMap;
    }
}

