/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.network;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public final class DNSUtils {
    private static DirContext dnsDirContext = null;

    private DNSUtils() {
    }

    private static DirContext getDnsDirContext() throws NamingException {
        if (dnsDirContext == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            dnsDirContext = new InitialDirContext(env);
        }
        return dnsDirContext;
    }

    public static List<String> lookup(String hostName, RecordType record) {
        Vector<String> result = new Vector<String>();
        try {
            Attributes attrs = DNSUtils.getDnsDirContext().getAttributes(hostName, new String[]{record.name()});
            Attribute attr = attrs.get(record.name());
            if (attr != null) {
                NamingEnumeration<?> attrEnum = attr.getAll();
                while (attrEnum.hasMoreElements()) {
                    result.add(attrEnum.next().toString());
                }
            }
        }
        catch (NamingException e) {
            return new Vector<String>();
        }
        return result;
    }

    public static List<String> lookupAll(String hostName) {
        Vector<String> result = new Vector<String>();
        for (RecordType drt : RecordType.values()) {
            result.addAll(DNSUtils.lookup(hostName, drt));
        }
        return result;
    }

    public static boolean isMatchingIpAddress(String hostName, String ipAddr) {
        List<String> allIps = DNSUtils.lookupAll(hostName);
        for (String ip : allIps) {
            if (!ip.equals(ipAddr)) continue;
            return true;
        }
        return false;
    }

    public static boolean exists(String hostName) {
        for (RecordType drt : RecordType.values()) {
            List<String> result = DNSUtils.lookup(hostName, drt);
            if (result.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static enum RecordType {
        A,
        CNAME,
        NS,
        MX,
        SOA;

    }
}

