/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.collection;

import java.util.HashMap;

public final class MapUtils {
    private MapUtils() {
    }

    public static HashMap<String, String> createHashMap(String ... values) {
        return MapUtils.createHashMapWithDelimiter("::", values);
    }

    public static HashMap<String, String> createHashMapWithDelimiter(String delimiter, String ... values) {
        HashMap<String, String> map = new HashMap<String, String>(values.length);
        for (String value : values) {
            String[] pair = value.split(delimiter);
            if (pair.length != 2 || pair[0].length() == 0 || pair[1].length() == 0) {
                throw new IllegalArgumentException("Invalid key-value-pair: " + value);
            }
            if (map.containsKey(pair[0])) {
                throw new IllegalArgumentException("Duplicate key: " + pair[0]);
            }
            map.put(pair[0], pair[1]);
        }
        return map;
    }
}

