/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.util.Formatter;
import java.util.Locale;

public final class ForbiddenViolation
implements Comparable<ForbiddenViolation> {
    public static final String SEPARATOR = "\n";
    private int groupId;
    public final Method targetMethod;
    public final String description;
    public final String locationInfo;
    public final int lineNo;
    public final Checker.ViolationSeverity severity;

    ForbiddenViolation(int groupId, String description, String locationInfo, int lineNo, Checker.ViolationSeverity severity) {
        this(groupId, null, description, locationInfo, lineNo, severity);
    }

    ForbiddenViolation(int groupId, Method targetMethod, String description, String locationInfo, int lineNo, Checker.ViolationSeverity severity) {
        this.groupId = groupId;
        this.targetMethod = targetMethod;
        this.description = description;
        this.locationInfo = locationInfo;
        this.lineNo = lineNo;
        this.severity = severity;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String format(String className, String source) {
        StringBuilder sb = new StringBuilder(this.description);
        sb.append(SEPARATOR).append("  in ").append(className);
        if (source != null) {
            if (this.lineNo >= 0) {
                new Formatter(sb, Locale.ENGLISH).format(" (%s:%d)", source, this.lineNo).flush();
            } else {
                new Formatter(sb, Locale.ENGLISH).format(" (%s, %s)", source, this.locationInfo).flush();
            }
        } else {
            new Formatter(sb, Locale.ENGLISH).format(" (%s)", this.locationInfo).flush();
        }
        return sb.toString();
    }

    @Override
    public int compareTo(ForbiddenViolation other) {
        if (this.groupId == other.groupId) {
            return Long.signum((long)this.lineNo - (long)other.lineNo);
        }
        return Long.signum((long)this.groupId - (long)other.groupId);
    }
}

