/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ClassMetadata;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenViolation;
import de.thetaphi.forbiddenapis.RelatedClassLoadingException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.Signatures;
import de.thetaphi.forbiddenapis.asm.AnnotationVisitor;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.FieldVisitor;
import de.thetaphi.forbiddenapis.asm.Handle;
import de.thetaphi.forbiddenapis.asm.Label;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.RecordComponentVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.TypePath;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class ClassScanner
extends ClassVisitor
implements Constants {
    private final boolean forbidNonPortableRuntime;
    final ClassMetadata metadata;
    final RelatedClassLookup lookup;
    final List<ForbiddenViolation> violations = new ArrayList<ForbiddenViolation>();
    final Signatures forbiddenSignatures;
    final Pattern suppressAnnotations;
    private String source = null;
    private boolean isDeprecated = false;
    private boolean done = false;
    int currentGroupId = 0;
    final Map<Method, Integer> lambdas = new HashMap<Method, Integer>();
    final BitSet suppressedGroups = new BitSet();
    boolean classSuppressed = false;
    private final boolean failOnViolation;
    private final AncestorVisitor classRelationAncestorVisitor = new AncestorVisitor(){

        @Override
        public Signatures.ViolationResult visit(ClassMetadata c, String origName, boolean isInterfaceOfAncestor, boolean previousInRuntime) {
            if (previousInRuntime && c.isNonPortableRuntime) {
                return null;
            }
            return ClassScanner.this.checkClassUse(c.className, isInterfaceOfAncestor ? "interface" : "class", origName);
        }
    };

    public ClassScanner(ClassMetadata metadata, RelatedClassLookup lookup, Signatures forbiddenSignatures, Pattern suppressAnnotations, boolean failOnViolation) {
        super(589824);
        this.metadata = metadata;
        this.lookup = lookup;
        this.forbiddenSignatures = forbiddenSignatures;
        this.suppressAnnotations = suppressAnnotations;
        this.forbidNonPortableRuntime = forbiddenSignatures.isNonPortableRuntimeForbidden();
        this.failOnViolation = failOnViolation;
    }

    private void checkDone() {
        if (this.done) {
            return;
        }
        throw new IllegalStateException("Class not fully scanned.");
    }

    public List<ForbiddenViolation> getSortedViolations() {
        this.checkDone();
        return this.classSuppressed ? Collections.emptyList() : Collections.unmodifiableList(this.violations);
    }

    public String getSourceFile() {
        return this.source;
    }

    Signatures.ViolationResult checkClassUse(Type type, String what, boolean isAnnotation, String origInternalName) {
        block7: {
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) {
                return null;
            }
            Signatures.ViolationResult violation = this.forbiddenSignatures.checkType(type, what);
            if (violation != null) {
                return violation;
            }
            if (this.forbidNonPortableRuntime) {
                try {
                    String binaryClassName = type.getClassName();
                    ClassMetadata c = this.lookup.lookupRelatedClass(type.getInternalName(), origInternalName);
                    if (c != null && c.isNonPortableRuntime) {
                        return new Signatures.ViolationResult(String.format(Locale.ENGLISH, "Forbidden %s use: %s [non-portable or internal runtime class]", what, binaryClassName), this.failOnViolation ? Checker.ViolationSeverity.ERROR : Checker.ViolationSeverity.WARNING);
                    }
                }
                catch (RelatedClassLoadingException e) {
                    if (isAnnotation) break block7;
                    throw e;
                }
            }
        }
        return null;
    }

    Signatures.ViolationResult checkClassUse(String internalName, String what, String origInternalName) {
        return this.checkClassUse(Type.getObjectType(internalName), what, false, origInternalName);
    }

    Signatures.ViolationResult visitAncestors(ClassMetadata cls, AncestorVisitor visitor, boolean visitSelf, boolean visitInterfacesFirst) {
        if (visitSelf) {
            Signatures.ViolationResult result = visitor.visit(cls, cls.className, cls.isInterface, cls.isRuntimeClass);
            if (result == AncestorVisitor.STOP) {
                return null;
            }
            if (result != null) {
                return result;
            }
        }
        return this.visitAncestorsRecursive(cls, cls.className, visitor, cls.isRuntimeClass, visitInterfacesFirst);
    }

    private Signatures.ViolationResult visitSuperclassRecursive(ClassMetadata cls, String origName, AncestorVisitor visitor, boolean previousInRuntime, boolean visitInterfacesFirst) {
        Signatures.ViolationResult result;
        ClassMetadata c;
        if (cls.superName != null && (c = this.lookup.lookupRelatedClass(cls.superName, origName)) != null && (result = visitor.visit(c, origName, false, previousInRuntime)) != AncestorVisitor.STOP) {
            if (result != null) {
                return result;
            }
            result = this.visitAncestorsRecursive(c, origName, visitor, cls.isRuntimeClass, visitInterfacesFirst);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private Signatures.ViolationResult visitInterfacesRecursive(ClassMetadata cls, String origName, AncestorVisitor visitor, boolean previousInRuntime, boolean visitInterfacesFirst) {
        if (cls.interfaces != null) {
            for (String intf : cls.interfaces) {
                Signatures.ViolationResult result;
                ClassMetadata c = this.lookup.lookupRelatedClass(intf, origName);
                if (c == null || (result = visitor.visit(c, origName, true, previousInRuntime)) == AncestorVisitor.STOP) continue;
                if (result != null) {
                    return result;
                }
                result = this.visitAncestorsRecursive(c, origName, visitor, cls.isRuntimeClass, visitInterfacesFirst);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Signatures.ViolationResult visitAncestorsRecursive(ClassMetadata cls, String origName, AncestorVisitor visitor, boolean previousInRuntime, boolean visitInterfacesFirst) {
        Signatures.ViolationResult result;
        if (visitInterfacesFirst && (result = this.visitInterfacesRecursive(cls, origName, visitor, previousInRuntime, visitInterfacesFirst)) != null) {
            return result;
        }
        result = this.visitSuperclassRecursive(cls, origName, visitor, previousInRuntime, visitInterfacesFirst);
        if (result != null) {
            return result;
        }
        if (!visitInterfacesFirst && (result = this.visitInterfacesRecursive(cls, origName, visitor, previousInRuntime, visitInterfacesFirst)) != null) {
            return result;
        }
        return null;
    }

    Signatures.ViolationResult checkType(Type type) {
        block5: while (type != null) {
            switch (type.getSort()) {
                case 10: {
                    String internalName = type.getInternalName();
                    Signatures.ViolationResult violation = this.checkClassUse(type, "class/interface", false, internalName);
                    if (violation != null) {
                        return violation;
                    }
                    ClassMetadata c = this.lookup.lookupRelatedClass(internalName, internalName);
                    return c == null ? null : this.visitAncestors(c, this.classRelationAncestorVisitor, false, false);
                }
                case 9: {
                    type = type.getElementType();
                    continue block5;
                }
                case 11: {
                    ArrayList<Signatures.ViolationResult> violations = new ArrayList<Signatures.ViolationResult>();
                    Signatures.ViolationResult violation = this.checkType(type.getReturnType());
                    if (violation != null) {
                        violations.add(violation);
                    }
                    for (Type t : type.getArgumentTypes()) {
                        violation = this.checkType(t);
                        if (violation == null) continue;
                        violations.add(violation);
                    }
                    if (violations.isEmpty()) {
                        return null;
                    }
                    if (violations.size() == 1) {
                        return (Signatures.ViolationResult)violations.get(0);
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean nl = false;
                    Checker.ViolationSeverity severity = null;
                    for (Signatures.ViolationResult v : violations) {
                        if (nl) {
                            sb.append("\n");
                        }
                        sb.append(v.message);
                        nl = true;
                        if (severity != null && v.severity.ordinal() <= severity.ordinal()) continue;
                        severity = v.severity;
                    }
                    return new Signatures.ViolationResult(sb.toString(), severity);
                }
            }
            return null;
        }
        return null;
    }

    Signatures.ViolationResult checkDescriptor(String desc) {
        return this.checkType(Type.getType(desc));
    }

    Signatures.ViolationResult checkAnnotationDescriptor(Type type, boolean visible) {
        return this.checkClassUse(type, "annotation", true, type.getInternalName());
    }

    void maybeSuppressCurrentGroup(Type annotation) {
        if (this.suppressAnnotations.matcher(annotation.getClassName()).matches()) {
            this.suppressedGroups.set(this.currentGroupId);
        }
    }

    private void reportClassViolation(Signatures.ViolationResult violation, String where) {
        if (violation != null) {
            this.violations.add(new ForbiddenViolation(this.currentGroupId, violation.message, where, -1, violation.severity));
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!Objects.equals(name, this.metadata.className)) {
            throw new AssertionError((Object)("Wrong class parsed: " + name));
        }
        this.isDeprecated = (access & 0x20000) != 0;
        this.reportClassViolation(this.visitAncestors(this.metadata, this.classRelationAncestorVisitor, false, false), "class declaration");
        if (this.isDeprecated) {
            this.classSuppressed |= this.suppressAnnotations.matcher(DEPRECATED_TYPE.getClassName()).matches();
            this.reportClassViolation(this.checkType(DEPRECATED_TYPE), "deprecation on class declaration");
        }
    }

    @Override
    public void visitSource(String source, String debug) {
        this.source = source;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isDeprecated && DEPRECATED_DESCRIPTOR.equals(desc)) {
            return null;
        }
        Type type = Type.getType(desc);
        this.classSuppressed |= this.suppressAnnotations.matcher(type.getClassName()).matches();
        this.reportClassViolation(this.checkAnnotationDescriptor(type, visible), "annotation on class declaration");
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.reportClassViolation(this.checkAnnotationDescriptor(Type.getType(desc), visible), "type annotation on class declaration");
        return null;
    }

    @Override
    public FieldVisitor visitField(final int access, final String name, final String desc, String signature, Object value) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new FieldVisitor(589824){
            final boolean isDeprecated;
            {
                super(x0);
                boolean bl = this.isDeprecated = (access & 0x20000) != 0;
                if ((access & 0x1000) == 0) {
                    this.reportFieldViolation(ClassScanner.this.checkDescriptor(desc), "field declaration");
                }
                if (this.isDeprecated) {
                    ClassScanner.this.maybeSuppressCurrentGroup(Constants.DEPRECATED_TYPE);
                    this.reportFieldViolation(ClassScanner.this.checkType(Constants.DEPRECATED_TYPE), "deprecation on field declaration");
                }
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (this.isDeprecated && Constants.DEPRECATED_DESCRIPTOR.equals(desc2)) {
                    return null;
                }
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportFieldViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on field declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportFieldViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on field declaration");
                return null;
            }

            private void reportFieldViolation(Signatures.ViolationResult violationResult, String where) {
                if (violationResult != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, violationResult.message, String.format(Locale.ENGLISH, "%s of '%s'", where, name), -1, violationResult.severity));
                }
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new MethodVisitor(589824){
            private final Method myself;
            private final boolean isDeprecated;
            private int lineNo;
            {
                super(x0);
                this.myself = new Method(name, desc);
                this.isDeprecated = (access & 0x20000) != 0;
                this.lineNo = -1;
                if ((access & 0x1000) == 0) {
                    this.reportMethodViolation(ClassScanner.this.checkDescriptor(desc), "method declaration");
                }
                if (this.isDeprecated) {
                    ClassScanner.this.maybeSuppressCurrentGroup(Constants.DEPRECATED_TYPE);
                    this.reportMethodViolation(ClassScanner.this.checkType(Constants.DEPRECATED_TYPE), "deprecation on method declaration");
                }
            }

            private Signatures.ViolationResult checkMethodAccess(String owner, final Method method, final boolean callIsVirtual) {
                if ("<clinit>".equals(method.getName())) {
                    return null;
                }
                Signatures.ViolationResult violation = ClassScanner.this.checkClassUse(owner, "class/interface", owner);
                if (violation != null) {
                    return violation;
                }
                violation = ClassScanner.this.forbiddenSignatures.checkMethod(owner, method);
                if (violation != null) {
                    return violation;
                }
                if ("<init>".equals(method.getName())) {
                    return null;
                }
                ClassMetadata c = ClassScanner.this.lookup.lookupRelatedClass(owner, owner);
                if (c == null) {
                    return null;
                }
                return ClassScanner.this.visitAncestors(c, new AncestorVisitor(){

                    @Override
                    public Signatures.ViolationResult visit(ClassMetadata c, String origName, boolean isInterfaceOfAncestor, boolean previousInRuntime) {
                        Signatures.ViolationResult notFoundRet;
                        Method lookupMethod = c.signaturePolymorphicMethods.contains(method.getName()) ? new Method(method.getName(), Constants.SIGNATURE_POLYMORPHIC_DESCRIPTOR) : method;
                        if (!c.methods.contains(lookupMethod)) {
                            return null;
                        }
                        Signatures.ViolationResult violationResult = notFoundRet = callIsVirtual ? null : AncestorVisitor.STOP;
                        if (previousInRuntime && c.isNonPortableRuntime) {
                            return notFoundRet;
                        }
                        Signatures.ViolationResult violation = ClassScanner.this.forbiddenSignatures.checkMethod(c.className, lookupMethod);
                        if (violation != null) {
                            return violation;
                        }
                        if (!isInterfaceOfAncestor && (violation = ClassScanner.this.checkClassUse(c.className, "class", origName)) != null) {
                            return violation;
                        }
                        return notFoundRet;
                    }
                }, true, false);
            }

            private Signatures.ViolationResult checkFieldAccess(String owner, final String field) {
                Signatures.ViolationResult violation = ClassScanner.this.checkClassUse(owner, "class/interface", owner);
                if (violation != null) {
                    return violation;
                }
                violation = ClassScanner.this.forbiddenSignatures.checkField(owner, field);
                if (violation != null) {
                    return violation;
                }
                ClassMetadata c = ClassScanner.this.lookup.lookupRelatedClass(owner, owner);
                if (c == null) {
                    return null;
                }
                return ClassScanner.this.visitAncestors(c, new AncestorVisitor(){

                    @Override
                    public Signatures.ViolationResult visit(ClassMetadata c, String origName, boolean isInterfaceOfAncestor, boolean previousInRuntime) {
                        if (!c.fields.contains(field)) {
                            return null;
                        }
                        if (previousInRuntime && c.isNonPortableRuntime) {
                            return STOP;
                        }
                        Signatures.ViolationResult violation = ClassScanner.this.forbiddenSignatures.checkField(c.className, field);
                        if (violation != null) {
                            return violation;
                        }
                        if (!isInterfaceOfAncestor && (violation = ClassScanner.this.checkClassUse(c.className, "class", origName)) != null) {
                            return violation;
                        }
                        return STOP;
                    }
                }, true, true);
            }

            private Signatures.ViolationResult checkHandle(Handle handle, boolean checkLambdaHandle) {
                switch (handle.getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return this.checkFieldAccess(handle.getOwner(), handle.getName());
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        Method m = new Method(handle.getName(), handle.getDesc());
                        if (checkLambdaHandle && handle.getOwner().equals(ClassScanner.this.metadata.className) && handle.getName().startsWith("lambda$")) {
                            ClassScanner.this.lambdas.put(m, ClassScanner.this.currentGroupId);
                        }
                        boolean callIsVirtual = handle.getTag() == 5 || handle.getTag() == 9;
                        return this.checkMethodAccess(handle.getOwner(), m, callIsVirtual);
                    }
                }
                return null;
            }

            private Signatures.ViolationResult checkConstant(Object cst, boolean checkLambdaHandle) {
                if (cst instanceof Type) {
                    return ClassScanner.this.checkType((Type)cst);
                }
                if (cst instanceof Handle) {
                    return this.checkHandle((Handle)cst, checkLambdaHandle);
                }
                return null;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (this.isDeprecated && Constants.DEPRECATED_DESCRIPTOR.equals(desc2)) {
                    return null;
                }
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "parameter annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                boolean callIsVirtual = opcode == 182 || opcode == 185;
                this.reportMethodViolation(this.checkMethodAccess(owner, new Method(name2, desc2), callIsVirtual), "method body");
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                this.reportMethodViolation(this.checkFieldAccess(owner, name2), "method body");
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 189) {
                    this.reportMethodViolation(ClassScanner.this.checkType(Type.getObjectType(type)), "method body");
                }
            }

            @Override
            public void visitMultiANewArrayInsn(String desc2, int dims) {
                this.reportMethodViolation(ClassScanner.this.checkDescriptor(desc2), "method body");
            }

            @Override
            public void visitLdcInsn(Object cst) {
                this.reportMethodViolation(this.checkConstant(cst, false), "method body");
            }

            @Override
            public void visitInvokeDynamicInsn(String name2, String desc2, Handle bsm, Object ... bsmArgs) {
                boolean isLambdaMetaFactory = "java/lang/invoke/LambdaMetafactory".equals(bsm.getOwner());
                this.reportMethodViolation(this.checkHandle(bsm, false), "method body");
                for (Object cst : bsmArgs) {
                    this.reportMethodViolation(this.checkConstant(cst, isLambdaMetaFactory), "method body");
                }
            }

            private String getHumanReadableMethodSignature() {
                Type[] args = Type.getType(this.myself.getDescriptor()).getArgumentTypes();
                StringBuilder sb = new StringBuilder(this.myself.getName()).append('(');
                boolean comma = false;
                for (Type t : args) {
                    if (comma) {
                        sb.append(',');
                    }
                    sb.append(t.getClassName());
                    comma = true;
                }
                sb.append(')');
                return sb.toString();
            }

            private void reportMethodViolation(Signatures.ViolationResult violation, String where) {
                if (violation != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, this.myself, violation.message, String.format(Locale.ENGLISH, "%s of '%s'", where, this.getHumanReadableMethodSignature()), this.lineNo, violation.severity));
                }
            }

            @Override
            public void visitLineNumber(int lineNo, Label start) {
                this.lineNo = lineNo;
            }
        };
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(final String name, final String desc, String signature) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new RecordComponentVisitor(589824){
            {
                super(x0);
                this.reportRecordComponentViolation(ClassScanner.this.checkDescriptor(desc), "record component declaration");
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportRecordComponentViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on record component declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportRecordComponentViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on record component declaration");
                return null;
            }

            private void reportRecordComponentViolation(Signatures.ViolationResult violationResult, String where) {
                if (violationResult != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, violationResult.message, String.format(Locale.ENGLISH, "%s of '%s'", where, name), -1, violationResult.severity));
                }
            }
        };
    }

    @Override
    public void visitEnd() {
        for (ForbiddenViolation v : this.violations) {
            Integer newGroupId;
            if (v.targetMethod == null || (newGroupId = this.lambdas.get(v.targetMethod)) == null) continue;
            v.setGroupId(newGroupId);
        }
        if (!this.suppressedGroups.isEmpty()) {
            Iterator<ForbiddenViolation> it = this.violations.iterator();
            while (it.hasNext()) {
                ForbiddenViolation v;
                v = it.next();
                if (!this.suppressedGroups.get(v.getGroupId())) continue;
                it.remove();
            }
        }
        Collections.sort(this.violations);
        this.done = true;
    }

    static interface AncestorVisitor {
        public static final Signatures.ViolationResult STOP = new Signatures.ViolationResult("STOP", null);

        public Signatures.ViolationResult visit(ClassMetadata var1, String var2, boolean var3, boolean var4);
    }
}

