/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Constants;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class VersionCompare {
    private static final Pattern DOT_SPLITTER_PATTERN = Pattern.compile("\\.");
    public static final Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String version1, String version2) {
            return VersionCompare.compareVersion(version1, version2);
        }
    };
    public static final Comparator<String> BUNDLED_SIGNATURES_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String bs1, String bs2) {
            return VersionCompare.compareBundledSignatures(bs1, bs2);
        }
    };

    private VersionCompare() {
    }

    public static int compareVersion(String version1, String version2) {
        String[] version1Splits = DOT_SPLITTER_PATTERN.split(version1);
        String[] version2Splits = DOT_SPLITTER_PATTERN.split(version2);
        int maxLengthOfVersionSplits = Math.max(version1Splits.length, version2Splits.length);
        for (int i = 0; i < maxLengthOfVersionSplits; ++i) {
            int v2;
            int v1 = i < version1Splits.length ? Integer.parseInt(version1Splits[i]) : 0;
            int compare = Integer.compare(v1, v2 = i < version2Splits.length ? Integer.parseInt(version2Splits[i]) : 0);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static int compareBundledSignatures(String bs1, String bs2) {
        Matcher m1 = Constants.ENDS_WITH_VERSION_PATTERN.matcher(bs1);
        Matcher m2 = Constants.ENDS_WITH_VERSION_PATTERN.matcher(bs2);
        if (m1.matches() && m2.matches()) {
            int prefixCmp = m1.group(1).compareTo(m2.group(1));
            if (prefixCmp != 0) {
                return prefixCmp;
            }
            return VersionCompare.compareVersion(m1.group(2), m2.group(2));
        }
        return bs1.compareTo(bs2);
    }
}

