/*
 * Decompiled with CFR 0.152.
 */
package org.scratchapi.scratchdsl;

import de.jonasbroeckmann.kzip.Zip;
import de.jonasbroeckmann.kzip.Zip_jvmKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scratchapi.scratchdsl.Asset;
import org.scratchapi.scratchdsl.AssetResource;
import org.scratchapi.scratchdsl.BuildRoot;
import org.scratchapi.scratchdsl.Costume;
import org.scratchapi.scratchdsl.NormalShadowExpressionShouldCopy;
import org.scratchapi.scratchdsl.ProjectJson;
import org.scratchapi.scratchdsl.Sound;
import org.scratchapi.scratchdsl.SpriteBuilder;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001f\u0010\f\u001a\u00020\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\r\u001a\u0012\u0010\u0014\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0018\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0019\u001a\u00020\u0016*\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0018\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\rH\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0018\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u001f\u001a\u00020\u0010*\u00020\u0013\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!*\n\u0010\u0000\"\u00020\u00012\u00020\u0001*\n\u0010\n\"\u00020\u000b2\u00020\u000b\u00a8\u0006\""}, d2={"AnyBlock", "Lorg/scratchapi/scratchdsl/Block;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "getHttp", "", "url", "", "Sprite", "Lorg/scratchapi/scratchdsl/SpriteBuilder;", "build", "Lorg/scratchapi/scratchdsl/BuildRoot;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "toProjectJsonContents", "Lorg/scratchapi/scratchdsl/ProjectJson;", "writeToProjectJsonPath", "path", "Ljava/nio/file/Path;", "modifyProject", "writeTo", "locateResource", "asset", "Lorg/scratchapi/scratchdsl/Asset;", "getResources", "", "Lorg/scratchapi/scratchdsl/AssetResource;", "output", "getPath", "(Ljava/lang/String;)Ljava/nio/file/Path;", "scratch-dsl"})
@SourceDebugExtension(value={"SMAP\nBuild.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Build.kt\norg/scratchapi/scratchdsl/BuildKt\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,745:1\n113#2:746\n1869#3:747\n1869#3,2:748\n1870#3:750\n1869#3:751\n1870#3:757\n1869#3,2:760\n216#4:752\n217#4:754\n216#4,2:755\n216#4,2:758\n1#5:753\n*S KotlinDebug\n*F\n+ 1 Build.kt\norg/scratchapi/scratchdsl/BuildKt\n*L\n598#1:746\n629#1:747\n631#1:748,2\n629#1:750\n646#1:751\n646#1:757\n705#1:760,2\n647#1:752\n647#1:754\n656#1:755,2\n695#1:758,2\n*E\n"})
public final class BuildKt {
    @NotNull
    private static final OkHttpClient httpClient = new OkHttpClient();

    @NotNull
    public static final OkHttpClient getHttpClient() {
        return httpClient;
    }

    @Nullable
    public static final byte[] getHttp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        Response response = httpClient.newCall(request).execute();
        ResponseBody responseBody = response.body();
        return (byte[])(responseBody != null ? responseBody.bytes() : null);
    }

    @NotNull
    public static final BuildRoot build(@NotNull Function1<? super BuildRoot, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BuildRoot buildRoot = new BuildRoot();
        block.invoke((Object)buildRoot);
        return buildRoot;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ProjectJson toProjectJsonContents(@NotNull BuildRoot $this$toProjectJsonContents) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toProjectJsonContents, (String)"<this>");
        StringFormat stringFormat = (StringFormat)Json.Default;
        JsonObject value$iv = $this$toProjectJsonContents.represent();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return new ProjectJson($this$encodeToString$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv), $this$toProjectJsonContents);
    }

    public static final void writeToProjectJsonPath(@NotNull BuildRoot $this$writeToProjectJsonPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToProjectJsonPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BuildKt.writeToProjectJsonPath(BuildKt.toProjectJsonContents($this$writeToProjectJsonPath), path);
    }

    public static final void modifyProject(@NotNull BuildRoot $this$modifyProject, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BuildKt.modifyProject(BuildKt.toProjectJsonContents($this$modifyProject), path);
    }

    public static final void writeTo(@NotNull BuildRoot $this$writeTo, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BuildKt.writeTo(BuildKt.toProjectJsonContents($this$writeTo), path);
    }

    @NotNull
    public static final Path locateResource(@NotNull BuildRoot $this$locateResource, @NotNull Asset asset) {
        Intrinsics.checkNotNullParameter((Object)$this$locateResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Iterable $this$forEach$iv = $this$locateResource.getAssetDirectories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path dir = (Path)element$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Iterable $this$forEach$iv2 = PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Path path = (Path)element$iv2;
                boolean bl2 = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)asset.getMd5Ext()) && !Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)(asset.getName() + "." + asset.getDataFormat()))) continue;
                return path;
            }
        }
        throw new IllegalArgumentException("Asset " + asset.getName() + "." + asset.getDataFormat() + " could not be located. Please pass its path or include the directory it is in in the assetDirectories of your BuildRoot.");
    }

    @NotNull
    public static final Map<String, AssetResource> getResources(@NotNull BuildRoot $this$getResources) {
        Intrinsics.checkNotNullParameter((Object)$this$getResources, (String)"<this>");
        Map resources = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$getResources.getTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String string;
            Map map;
            Map.Entry<String, Costume> entry;
            Map.Entry<String, NormalShadowExpressionShouldCopy> element$iv2;
            SpriteBuilder target = (SpriteBuilder)element$iv;
            boolean bl = false;
            Map<String, NormalShadowExpressionShouldCopy> $this$forEach$iv2 = target.getCostumes();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, NormalShadowExpressionShouldCopy>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                AssetResource assetResource;
                entry = element$iv2 = iterator.next();
                boolean bl2 = false;
                Costume costume = entry.getValue();
                map = resources;
                string = costume.getMd5Ext();
                if (costume.getPath() != null) {
                    assetResource = new AssetResource(null, costume.getPath(), 1, null);
                } else if (costume.getData() != null) {
                    Buffer $this$getResources_u24lambda_u246_u24lambda_u243_u24lambda_u242 = object = new Buffer();
                    boolean bl3 = false;
                    Sink.write$default((Sink)((Sink)$this$getResources_u24lambda_u246_u24lambda_u243_u24lambda_u242), (byte[])costume.getData(), (int)0, (int)0, (int)6, null);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Path path = null;
                    Source source = (Source)object;
                    assetResource = new AssetResource(source, path, n, defaultConstructorMarker);
                } else {
                    assetResource = new AssetResource(null, BuildKt.locateResource($this$getResources, costume), 1, null);
                }
                object = assetResource;
                map.put(string, object);
            }
            $this$forEach$iv2 = target.getSounds();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                AssetResource assetResource;
                entry = element$iv2 = iterator.next();
                boolean bl4 = false;
                Sound sound = (Sound)((Object)entry.getValue());
                map = resources;
                string = sound.getMd5Ext();
                if (sound.getPath() != null) {
                    assetResource = new AssetResource(null, sound.getPath(), 1, null);
                } else if (sound.getData() != null) {
                    Object $this$getResources_u24lambda_u246_u24lambda_u245_u24lambda_u244 = object = new Buffer();
                    boolean bl5 = false;
                    Sink.write$default((Sink)((Sink)$this$getResources_u24lambda_u246_u24lambda_u245_u24lambda_u244), (byte[])sound.getData(), (int)0, (int)0, (int)6, null);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Path path = null;
                    Source source = (Source)object;
                    assetResource = new AssetResource(source, path, n, defaultConstructorMarker);
                } else {
                    assetResource = new AssetResource(null, BuildKt.locateResource($this$getResources, sound), 1, null);
                }
                object = assetResource;
                map.put(string, object);
            }
        }
        return resources;
    }

    public static final void writeToProjectJsonPath(@NotNull ProjectJson $this$writeToProjectJsonPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToProjectJsonPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PathsKt.writeText$default((Path)path, (CharSequence)$this$writeToProjectJsonPath.getString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void modifyProject(@NotNull ProjectJson $this$modifyProject, @NotNull Path path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$modifyProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Buffer $this$modifyProject_u24lambda_u247 = object = new Buffer();
        boolean bl = false;
        Utf8Kt.writeString$default((Sink)((Sink)$this$modifyProject_u24lambda_u247), (String)$this$modifyProject.getString(), (int)0, (int)0, (int)6, null);
        object = (AutoCloseable)object;
        Throwable throwable = null;
        try {
            Object textSource = object;
            boolean bl2 = false;
            AutoCloseable autoCloseable = (AutoCloseable)Zip_jvmKt.open$default((Zip.Companion)Zip.Companion, (kotlinx.io.files.Path)PathsJvmKt.Path((String)((Object)path).toString()), (Zip.Mode)Zip.Mode.Append, null, (int)4, null);
            Throwable throwable2 = null;
            try {
                Zip zip = (Zip)autoCloseable;
                boolean bl3 = false;
                zip.entryFromSource(PathsJvmKt.Path((String)"project.json"), (Source)textSource);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeTo(@NotNull ProjectJson $this$writeTo, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map<String, AssetResource> resources = BuildKt.getResources($this$writeTo.getBuildRoot());
        try {
            Object object;
            Object $this$writeTo_u24lambda_u2410 = object = new Buffer();
            boolean bl = false;
            Utf8Kt.writeString$default((Sink)((Sink)$this$writeTo_u24lambda_u2410), (String)$this$writeTo.getString(), (int)0, (int)0, (int)6, null);
            object = (AutoCloseable)object;
            $this$writeTo_u24lambda_u2410 = null;
            try {
                Object textSource = object;
                boolean bl2 = false;
                AutoCloseable autoCloseable = (AutoCloseable)Zip_jvmKt.open$default((Zip.Companion)Zip.Companion, (kotlinx.io.files.Path)PathsJvmKt.Path((String)((Object)path).toString()), (Zip.Mode)Zip.Mode.Write, null, (int)4, null);
                Throwable throwable = null;
                try {
                    Zip zip = (Zip)autoCloseable;
                    boolean bl3 = false;
                    zip.entryFromSource(PathsJvmKt.Path((String)"project.json"), (Source)textSource);
                    Map<String, AssetResource> $this$forEach$iv = resources;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<String, AssetResource>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Path it;
                        Map.Entry<String, AssetResource> element$iv;
                        Map.Entry<String, AssetResource> entry = element$iv = iterator.next();
                        boolean bl4 = false;
                        String name = entry.getKey();
                        AssetResource resource = entry.getValue();
                        if (resource.getSource() != null) {
                            Source it2;
                            boolean bl5 = false;
                            zip.entryFromSource(PathsJvmKt.Path((String)name), it2);
                            continue;
                        }
                        if (resource.getPath() == null) continue;
                        boolean bl6 = false;
                        zip.entryFromPath(PathsJvmKt.Path((String)name), PathsJvmKt.Path((String)((Object)it).toString()));
                    }
                    zip = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                textSource = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                $this$writeTo_u24lambda_u2410 = bl2;
                throw bl2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$this$writeTo_u24lambda_u2410);
            }
        }
        finally {
            Iterable $this$forEach$iv = resources.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AutoCloseable p0 = (AutoCloseable)element$iv;
                boolean bl = false;
                p0.close();
            }
        }
    }

    public static final void output(@NotNull ProjectJson $this$output) {
        Intrinsics.checkNotNullParameter((Object)$this$output, (String)"<this>");
        System.out.println((Object)$this$output.getString());
    }

    @NotNull
    public static final Path getPath(@NotNull String $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        Path path = Paths.get($this$path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }
}

