/*
 * Decompiled with CFR 0.152.
 */
package org.scratchapi.scratchdsl;

import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scratchapi.scratchdsl.Backdrop;
import org.scratchapi.scratchdsl.Costume;
import org.scratchapi.scratchdsl.Expression;
import org.scratchapi.scratchdsl.Sound;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0005H\u0000\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000eH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u00a8\u0006\u0011"}, d2={"getChecksum", "", "path", "Ljava/nio/file/Path;", "loadCostume", "Lorg/scratchapi/scratchdsl/Costume;", "name", "bitmapResolution", "", "rotationCenter", "Lkotlin/Pair;", "", "asBackdrop", "Lorg/scratchapi/scratchdsl/Backdrop;", "Lorg/scratchapi/scratchdsl/Expression;", "loadSound", "Lorg/scratchapi/scratchdsl/Sound;", "scratch-dsl"})
public final class AttachmentsKt {
    @NotNull
    public static final String getChecksum(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] data = Files.readAllBytes(path);
        byte[] hash = MessageDigest.getInstance("MD5").digest(data);
        String string = new BigInteger(1, hash).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final Costume loadCostume(@NotNull Path path, @NotNull String name, int bitmapResolution, @Nullable Pair<Double, Double> rotationCenter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String checksum = AttachmentsKt.getChecksum(path);
        String string = PathsKt.getExtension((Path)path);
        return new Costume(name, string, checksum, rotationCenter, bitmapResolution, path, null, 64, null);
    }

    public static /* synthetic */ Costume loadCostume$default(Path path, String string, int n, Pair pair, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            pair = null;
        }
        return AttachmentsKt.loadCostume(path, string, n, (Pair<Double, Double>)pair);
    }

    @NotNull
    public static final Backdrop asBackdrop(@NotNull Costume $this$asBackdrop) {
        Intrinsics.checkNotNullParameter((Object)$this$asBackdrop, (String)"<this>");
        return new Backdrop($this$asBackdrop.getName(), $this$asBackdrop);
    }

    @Nullable
    public static final Expression asBackdrop(@Nullable Expression $this$asBackdrop) {
        if ($this$asBackdrop instanceof Costume) {
            return AttachmentsKt.asBackdrop((Costume)$this$asBackdrop);
        }
        return $this$asBackdrop;
    }

    @NotNull
    public static final Sound loadSound(@NotNull Path path, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String checksum = AttachmentsKt.getChecksum(path);
        return new Sound(name, PathsKt.getExtension((Path)path), checksum, null, null, path, null, 88, null);
    }
}

