/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.model.util;

import de.tesis.dynaware.grapheditor.model.GConnectable;
import de.tesis.dynaware.grapheditor.model.GConnection;
import de.tesis.dynaware.grapheditor.model.GConnector;
import de.tesis.dynaware.grapheditor.model.GJoint;
import de.tesis.dynaware.grapheditor.model.GModel;
import de.tesis.dynaware.grapheditor.model.GNode;
import de.tesis.dynaware.grapheditor.model.GraphPackage;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class GraphValidator
extends EObjectValidator {
    public static final GraphValidator INSTANCE = new GraphValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.tesis.dynaware.javafx.grapheditor.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String GMODEL__IS_CONTENT_WIDTH_VALID__EEXPRESSION = "contentWidth >= 0";
    protected static final String GMODEL__IS_CONTENT_HEIGHT_VALID__EEXPRESSION = "contentHeight >= 0";
    protected static final String GNODE__IS_WIDTH_VALID__EEXPRESSION = "width >= 0";
    protected static final String GNODE__IS_HEIGHT_VALID__EEXPRESSION = "height >= 0";

    protected EPackage getEPackage() {
        return GraphPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGModel((GModel)value, diagnostics, context);
            }
            case 2: {
                return this.validateGNode((GNode)value, diagnostics, context);
            }
            case 4: {
                return this.validateGConnector((GConnector)value, diagnostics, context);
            }
            case 3: {
                return this.validateGConnection((GConnection)value, diagnostics, context);
            }
            case 5: {
                return this.validateGJoint((GJoint)value, diagnostics, context);
            }
            case 1: {
                return this.validateGConnectable((GConnectable)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGModel(GModel gModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gModel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gModel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGModel_isContentWidthValid(gModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGModel_isContentHeightValid(gModel, diagnostics, context);
        }
        return result;
    }

    public boolean validateGModel_isContentHeightValid(GModel gModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.GMODEL, gModel, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "isContentHeightValid", GMODEL__IS_CONTENT_HEIGHT_VALID__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGModel_isContentWidthValid(GModel gModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.GMODEL, gModel, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "isContentWidthValid", GMODEL__IS_CONTENT_WIDTH_VALID__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGNode(GNode gNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gNode, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gNode, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGNode_isWidthValid(gNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGNode_isHeightValid(gNode, diagnostics, context);
        }
        return result;
    }

    public boolean validateGNode_isWidthValid(GNode gNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.GNODE, gNode, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "isWidthValid", GNODE__IS_WIDTH_VALID__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGNode_isHeightValid(GNode gNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.GNODE, gNode, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "isHeightValid", GNODE__IS_HEIGHT_VALID__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGConnector(GConnector gConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(gConnector, diagnostics, context);
    }

    public boolean validateGConnection(GConnection gConnection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(gConnection, diagnostics, context);
    }

    public boolean validateGJoint(GJoint gJoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(gJoint, diagnostics, context);
    }

    public boolean validateGConnectable(GConnectable gConnectable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(gConnectable, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

