/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.window.MinimapContentRepresentation;
import de.tesis.dynaware.grapheditor.window.MinimapLocator;
import de.tesis.dynaware.grapheditor.window.PanningWindow;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Transform;

public class PanningWindowMinimap
extends Pane {
    protected static final double MINIMAP_PADDING = 5.0;
    private static final String STYLESHEET = "minimap.css";
    private static final String STYLE_CLASS = "minimap";
    private final MinimapLocator locator = new MinimapLocator(5.0);
    private MinimapContentRepresentation contentRepresentation;
    private PanningWindow window;
    private Region content;
    private ChangeListener<Transform> zoomListener;
    private ChangeListener<Number> drawListener;
    private ChangeListener<Number> drawLocatorListener;
    private boolean locatorPositionListenersMuted;
    private boolean drawLocatorListenerMuted;

    public PanningWindowMinimap() {
        this.getStylesheets().add((Object)PanningWindowMinimap.class.getResource(STYLESHEET).toExternalForm());
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.setPickOnBounds(false);
        this.createZoomListener();
        this.createVisibilityChangeListener();
        this.createDrawListener();
        this.createDrawLocatorListener();
        this.createLocatorPositionListeners();
        this.createMinimapClickHandlers();
        this.createContentCacheHandlersForLocator();
        this.getChildren().addAll((Object[])new Node[]{this.locator});
    }

    public void setContentRepresentation(MinimapContentRepresentation contentRepresentation) {
        if (this.contentRepresentation != null) {
            this.getChildren().remove((Object)this.contentRepresentation);
        }
        this.contentRepresentation = contentRepresentation;
        if (contentRepresentation != null) {
            contentRepresentation.setLayoutX(5.0);
            contentRepresentation.setLayoutY(5.0);
            this.getChildren().add((Object)contentRepresentation);
            this.locator.toFront();
        }
    }

    public void setWindow(PanningWindow window) {
        if (this.window != null) {
            this.window.widthProperty().removeListener(this.drawLocatorListener);
            this.window.heightProperty().removeListener(this.drawLocatorListener);
        }
        this.window = window;
        if (this.window != null) {
            window.widthProperty().addListener(this.drawLocatorListener);
            window.heightProperty().addListener(this.drawLocatorListener);
        }
        if (this.isVisible()) {
            this.drawLocator();
        }
    }

    public void setContent(Region content) {
        if (this.content != null) {
            this.content.layoutXProperty().removeListener(this.drawLocatorListener);
            this.content.layoutYProperty().removeListener(this.drawLocatorListener);
            this.content.widthProperty().removeListener(this.drawListener);
            this.content.heightProperty().removeListener(this.drawListener);
            this.content.localToSceneTransformProperty().removeListener(this.zoomListener);
        }
        this.content = content;
        if (content != null) {
            content.widthProperty().addListener(this.drawListener);
            content.heightProperty().addListener(this.drawListener);
            content.layoutXProperty().addListener(this.drawLocatorListener);
            content.layoutYProperty().addListener(this.drawLocatorListener);
            content.localToSceneTransformProperty().addListener(this.zoomListener);
        } else if (this.contentRepresentation != null) {
            this.contentRepresentation.getChildren().clear();
        }
        if (this.isVisible()) {
            this.drawLocator();
        }
    }

    protected double calculateScaleFactor() {
        double scaleFactorX = (this.getWidth() - 10.0) / this.content.getWidth();
        double scaleFactorY = (this.getHeight() - 10.0) / this.content.getHeight();
        return Math.min(scaleFactorX, scaleFactorY);
    }

    private void createZoomListener() {
        this.zoomListener = (observable, oldValue, newValue) -> this.drawLocator();
    }

    private void createVisibilityChangeListener() {
        this.visibleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.drawAll();
            }
        });
    }

    private void createDrawListener() {
        this.drawListener = (observable, oldValue, newValue) -> {
            if (this.isVisible()) {
                this.drawAll();
            }
        };
    }

    private void createDrawLocatorListener() {
        this.drawLocatorListener = (observable, oldValue, newValue) -> {
            if (this.isVisible()) {
                this.drawLocator();
            }
        };
        this.widthProperty().addListener(this.drawLocatorListener);
        this.heightProperty().addListener(this.drawLocatorListener);
    }

    private void createLocatorPositionListeners() {
        this.locator.layoutXProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.locatorPositionListenersMuted && this.checkContentExists() && this.checkWindowExists()) {
                this.drawLocatorListenerMuted = true;
                double effectiveScaleFactor = this.calculateScaleFactor() / this.calculateZoomFactor();
                double targetX = ((Double)newValue - 5.0) / effectiveScaleFactor;
                this.window.panTo(targetX, this.window.windowYProperty().get());
                this.drawLocatorListenerMuted = false;
            }
        });
        this.locator.layoutYProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.locatorPositionListenersMuted && this.checkContentExists() && this.checkWindowExists()) {
                this.drawLocatorListenerMuted = true;
                double effectiveScaleFactor = this.calculateScaleFactor() / this.calculateZoomFactor();
                double targetY = ((Double)newValue - 5.0) / effectiveScaleFactor;
                this.window.panTo(this.window.windowXProperty().get(), targetY);
                this.drawLocatorListenerMuted = false;
            }
        });
    }

    private void createMinimapClickHandlers() {
        this.setOnMousePressed(event -> {
            if (!this.checkReadyForClickEvent((MouseEvent)event)) {
                return;
            }
            if (this.window.isCacheWhilePanning()) {
                this.content.setCache(true);
            }
            double x = event.getX() - 5.0 - this.locator.getWidth() / 2.0;
            double y = event.getY() - 5.0 - this.locator.getHeight() / 2.0;
            double scaleFactor = this.calculateScaleFactor();
            double zoomFactor = this.calculateZoomFactor();
            this.window.panTo(x / scaleFactor * zoomFactor, y / scaleFactor * zoomFactor);
            this.locator.fireEvent(event);
        });
        this.setOnMouseDragged(event -> {
            if (this.checkReadyForClickEvent((MouseEvent)event)) {
                this.locator.fireEvent(event);
            }
        });
        this.setOnMouseReleased(event -> {
            if (this.checkReadyForClickEvent((MouseEvent)event) && this.window.isCacheWhilePanning()) {
                this.content.setCache(false);
            }
        });
    }

    private void createContentCacheHandlersForLocator() {
        EventHandler existingPressedHandler = this.locator.getOnMousePressed();
        EventHandler existingReleasedHandler = this.locator.getOnMouseReleased();
        this.locator.setOnMousePressed(event -> {
            if (this.checkReadyForClickEvent((MouseEvent)event) && this.window.isCacheWhilePanning()) {
                this.content.setCache(true);
            }
            if (existingPressedHandler != null) {
                existingPressedHandler.handle(event);
            }
        });
        this.locator.setOnMouseReleased(event -> {
            if (this.checkReadyForClickEvent((MouseEvent)event) && this.window.isCacheWhilePanning()) {
                this.content.setCache(false);
            }
            if (existingReleasedHandler != null) {
                existingReleasedHandler.handle(event);
            }
        });
    }

    private void drawAll() {
        this.drawContentRepresentation();
        this.drawLocator();
    }

    private void drawContentRepresentation() {
        if (this.checkContentExists() && this.checkWindowExists() && this.contentRepresentation != null) {
            this.contentRepresentation.draw(this.calculateScaleFactor());
        }
    }

    private void drawLocator() {
        if (this.checkContentExists() && this.checkWindowExists() && !this.drawLocatorListenerMuted) {
            this.locatorPositionListenersMuted = true;
            this.locator.draw(this.window, this.content, this.calculateScaleFactor(), this.calculateZoomFactor());
            this.locatorPositionListenersMuted = false;
        }
    }

    private double calculateZoomFactor() {
        return this.content.getLocalToSceneTransform().getMxx();
    }

    private boolean checkReadyForClickEvent(MouseEvent event) {
        return event.getButton().equals((Object)MouseButton.PRIMARY) && this.checkContentExists() && this.checkWindowExists();
    }

    private boolean checkContentExists() {
        return this.content != null && this.content.getWidth() > 0.0 && this.content.getHeight() > 0.0;
    }

    private boolean checkWindowExists() {
        return this.window != null && this.window.getWidth() > 0.0 && this.window.getHeight() > 0.0;
    }
}

