/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.window.AutoScrollingParameters;
import de.tesis.dynaware.grapheditor.window.PanningWindow;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class AutoScrollingWindow
extends PanningWindow {
    private final AutoScrollingParameters parameters = new AutoScrollingParameters();
    private Timeline timeline;
    private MouseEvent currentDragEvent;
    private Node dragEventTarget;
    private boolean isScrolling;
    private Point2D jumpDistance;
    private boolean autoScrollingEnabled = true;
    private int jumpsTaken;

    public AutoScrollingWindow() {
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
    }

    public boolean isAutoScrollingEnabled() {
        return this.autoScrollingEnabled;
    }

    public void setAutoScrollingEnabled(boolean autoScrollingEnabled) {
        this.autoScrollingEnabled = autoScrollingEnabled;
    }

    public AutoScrollingParameters getAutoScrollingParameters() {
        return this.parameters;
    }

    private void handleMouseDragged(MouseEvent event) {
        if (event.isPrimaryButtonDown() && event.getTarget() instanceof Node) {
            this.currentDragEvent = event;
            this.dragEventTarget = (Node)event.getTarget();
            this.jumpDistance = this.getDistanceToJump(event.getX(), event.getY());
            if (this.jumpDistance == null) {
                this.jumpsTaken = 0;
            } else if (!this.isScrolling && this.isAutoScrollingEnabled()) {
                this.startScrolling();
            }
        }
    }

    private void handleMouseReleased(MouseEvent event) {
        this.dragEventTarget = null;
        this.endScrolling();
    }

    private Point2D getDistanceToJump(double cursorX, double cursorY) {
        double jumpX = 0.0;
        double jumpY = 0.0;
        double baseAmount = this.parameters.getBaseJumpAmount();
        double additionalAmount = (double)this.jumpsTaken * this.parameters.getJumpAmountIncreasePerJump();
        double distance = Math.min(baseAmount + additionalAmount, this.parameters.getMaxJumpAmount());
        if (cursorX <= this.parameters.getInsetToBeginScroll()) {
            jumpX = -distance;
        } else if (cursorX >= this.getWidth() - this.parameters.getInsetToBeginScroll()) {
            jumpX = distance;
        }
        if (cursorY <= this.parameters.getInsetToBeginScroll()) {
            jumpY = -distance;
        } else if (cursorY >= this.getHeight() - this.parameters.getInsetToBeginScroll()) {
            jumpY = distance;
        }
        if (jumpX == 0.0 && jumpY == 0.0) {
            return null;
        }
        return new Point2D((double)Math.round(jumpX), (double)Math.round(jumpY));
    }

    private void startScrolling() {
        this.isScrolling = true;
        this.jumpsTaken = 0;
        KeyFrame frame = new KeyFrame(Duration.millis((double)this.parameters.getJumpPeriod()), event -> {
            if (this.dragEventTarget != null && this.isScrolling && this.jumpDistance != null) {
                this.panBy(this.jumpDistance.getX(), this.jumpDistance.getY());
                this.dragEventTarget.fireEvent((Event)this.currentDragEvent);
                ++this.jumpsTaken;
            }
        }, new KeyValue[0]);
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add((Object)frame);
        this.timeline.play();
    }

    private void endScrolling() {
        this.isScrolling = false;
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }
}

