/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Rotate;

public class ArrowHead
extends Path {
    private static final double DEFAULT_LENGTH = 10.0;
    private static final double DEFAULT_WIDTH = 10.0;
    private double x;
    private double y;
    private double length = 10.0;
    private double width = 10.0;
    private double radius = -1.0;
    private final Rotate rotate = new Rotate();

    public ArrowHead() {
        this.setFill((Paint)Color.BLACK);
        this.setStrokeType(StrokeType.INSIDE);
        this.getTransforms().add((Object)this.rotate);
    }

    public void setCenter(double x, double y) {
        this.x = x;
        this.y = y;
        this.rotate.setPivotX(x);
        this.rotate.setPivotY(y);
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setRadiusOfCurvature(double radius) {
        this.radius = radius;
    }

    public void setAngle(double angle) {
        this.rotate.setAngle(angle);
    }

    public void draw() {
        this.getElements().clear();
        this.getElements().add((Object)new MoveTo(this.x, this.y + this.length / 2.0));
        this.getElements().add((Object)new LineTo(this.x + this.width / 2.0, this.y - this.length / 2.0));
        if (this.radius > 0.0) {
            ArcTo arcTo = new ArcTo();
            arcTo.setX(this.x - this.width / 2.0);
            arcTo.setY(this.y - this.length / 2.0);
            arcTo.setRadiusX(this.radius);
            arcTo.setRadiusY(this.radius);
            arcTo.setSweepFlag(true);
            this.getElements().add((Object)arcTo);
        } else {
            this.getElements().add((Object)new LineTo(this.x - this.width / 2.0, this.y - this.length / 2.0));
        }
        this.getElements().add((Object)new ClosePath());
    }
}

