/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import de.tesis.dynaware.grapheditor.utils.ArrowHead;
import de.tesis.dynaware.grapheditor.utils.GeometryUtils;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Line;

public class Arrow
extends Group {
    private static final String STYLE_CLASS_LINE = "arrow-line";
    private static final String STYLE_CLASS_HEAD = "arrow-head";
    private final Line line = new Line();
    private final ArrowHead head = new ArrowHead();
    private double startX;
    private double startY;
    private double endX;
    private double endY;

    public Arrow() {
        this.line.getStyleClass().add((Object)STYLE_CLASS_LINE);
        this.head.getStyleClass().add((Object)STYLE_CLASS_HEAD);
        this.getChildren().addAll((Object[])new Node[]{this.line, this.head});
    }

    public void setHeadWidth(double width) {
        this.head.setWidth(width);
    }

    public void setHeadLength(double length) {
        this.head.setLength(length);
    }

    public void setHeadRadius(double radius) {
        this.head.setRadiusOfCurvature(radius);
    }

    public Point2D getStart() {
        return new Point2D(this.startX, this.startY);
    }

    public void setStart(double startX, double startY) {
        this.startX = startX;
        this.startY = startY;
    }

    public Point2D getEnd() {
        return new Point2D(this.endX, this.endY);
    }

    public void setEnd(double endX, double endY) {
        this.endX = endX;
        this.endY = endY;
    }

    public void draw() {
        double deltaX = this.endX - this.startX;
        double deltaY = this.endY - this.startY;
        double angle = Math.atan2(deltaX, deltaY);
        double headX = this.endX - this.head.getLength() / 2.0 * Math.sin(angle);
        double headY = this.endY - this.head.getLength() / 2.0 * Math.cos(angle);
        this.line.setStartX(GeometryUtils.moveOffPixel(this.startX));
        this.line.setStartY(GeometryUtils.moveOffPixel(this.startY));
        this.line.setEndX(GeometryUtils.moveOffPixel(headX));
        this.line.setEndY(GeometryUtils.moveOffPixel(headY));
        this.head.setCenter(headX, headY);
        this.head.setAngle(Math.toDegrees(-angle));
        this.head.draw();
    }
}

