/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.window.PanningWindow;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class AutoScrollingWindow
extends PanningWindow {
    private Timeline timeline;
    private MouseEvent currentDragEvent;
    private Node dragEventTarget;
    private boolean isScrolling;
    private Point2D jumpDistance;
    private boolean autoScrollingEnabled = true;
    private double jumpPeriod = 25.0;
    private double baseJumpAmount = 10.0;
    private double maxJumpAmount = 50.0;
    private double jumpAmountIncreasePerPixel = 0.1;
    private double insetToBeginScroll = 1.0;

    public AutoScrollingWindow() {
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
    }

    public boolean isAutoScrollingEnabled() {
        return this.autoScrollingEnabled;
    }

    public void setAutoScrollingEnabled(boolean autoScrollingEnabled) {
        this.autoScrollingEnabled = autoScrollingEnabled;
    }

    public double getJumpPeriod() {
        return this.jumpPeriod;
    }

    public void setJumpPeriod(double jumpPeriod) {
        this.jumpPeriod = jumpPeriod;
    }

    public double getBaseJumpAmount() {
        return this.baseJumpAmount;
    }

    public void setBaseJumpAmount(double baseJumpAmount) {
        this.baseJumpAmount = baseJumpAmount;
    }

    public double getMaxJumpAmount() {
        return this.maxJumpAmount;
    }

    public void setMaxJumpAmount(double maxJumpAmount) {
        this.maxJumpAmount = maxJumpAmount;
    }

    public double getJumpAmountIncreasePerPixel() {
        return this.jumpAmountIncreasePerPixel;
    }

    public void setJumpAmountIncreasePerPixel(double jumpAmountIncreasePerPixel) {
        this.jumpAmountIncreasePerPixel = jumpAmountIncreasePerPixel;
    }

    public double getInsetToBeginScroll() {
        return this.insetToBeginScroll;
    }

    public void setInsetToBeginScroll(double insetToBeginScroll) {
        this.insetToBeginScroll = insetToBeginScroll;
    }

    private void handleMouseDragged(MouseEvent event) {
        if (event.isPrimaryButtonDown() && event.getTarget() instanceof Node) {
            this.currentDragEvent = event;
            this.dragEventTarget = (Node)event.getTarget();
            this.jumpDistance = this.getDistanceToJump(event.getX(), event.getY());
            if (this.jumpDistance != null && !this.isScrolling) {
                this.startScrolling();
            }
        }
    }

    private void handleMouseReleased(MouseEvent event) {
        this.dragEventTarget = null;
        this.endScrolling();
    }

    private Point2D getDistanceToJump(double cursorX, double cursorY) {
        double distanceOutside;
        double jumpX = 0.0;
        double jumpY = 0.0;
        if (cursorX <= this.insetToBeginScroll) {
            distanceOutside = this.insetToBeginScroll - cursorX;
            jumpX = -this.baseJumpAmount - distanceOutside * this.jumpAmountIncreasePerPixel;
            jumpX = Math.max(jumpX, -this.maxJumpAmount);
        } else if (cursorX >= this.getWidth() - this.insetToBeginScroll) {
            distanceOutside = cursorX + this.insetToBeginScroll - this.getWidth();
            jumpX = this.baseJumpAmount + distanceOutside * this.jumpAmountIncreasePerPixel;
            jumpX = Math.min(jumpX, this.maxJumpAmount);
        }
        if (cursorY <= this.insetToBeginScroll) {
            distanceOutside = this.insetToBeginScroll - cursorY;
            jumpY = -this.baseJumpAmount - distanceOutside * this.jumpAmountIncreasePerPixel;
            jumpY = Math.max(jumpY, -this.maxJumpAmount);
        } else if (cursorY >= this.getHeight() - this.insetToBeginScroll) {
            distanceOutside = cursorY + this.insetToBeginScroll - this.getHeight();
            jumpY = this.baseJumpAmount + distanceOutside * this.jumpAmountIncreasePerPixel;
            jumpY = Math.min(jumpY, this.maxJumpAmount);
        }
        if (jumpX == 0.0 && jumpY == 0.0) {
            return null;
        }
        return new Point2D((double)Math.round(jumpX), (double)Math.round(jumpY));
    }

    private void startScrolling() {
        this.isScrolling = true;
        KeyFrame frame = new KeyFrame(Duration.millis((double)this.jumpPeriod), event -> {
            if (this.dragEventTarget != null && this.isScrolling && this.jumpDistance != null) {
                this.panBy(this.jumpDistance.getX(), this.jumpDistance.getY());
                this.dragEventTarget.fireEvent((Event)this.currentDragEvent);
            }
        }, new KeyValue[0]);
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add((Object)frame);
        this.timeline.play();
    }

    private void endScrolling() {
        this.isScrolling = false;
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }
}

